/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.block.entity;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.entity.TickableBlockEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.level.block.entity.SkullBlockEntityBridge;
import org.spongepowered.common.profile.SpongeGameProfile;

@Mixin(value={SkullBlockEntity.class})
public abstract class SkullBlockEntityMixin
extends BlockEntity
implements TickableBlockEntity,
SkullBlockEntityBridge {
    @Shadow
    private com.mojang.authlib.GameProfile owner;
    private @org.checkerframework.checker.nullness.qual.Nullable CompletableFuture<?> impl$currentProfileFuture;

    @Shadow
    public abstract void shadow$setOwner(@Nullable com.mojang.authlib.GameProfile var1);

    public SkullBlockEntityMixin(BlockEntityType<?> type) {
        super(type);
    }

    private void cancelResolveFuture() {
        if (this.impl$currentProfileFuture != null) {
            this.impl$currentProfileFuture.cancel(true);
            this.impl$currentProfileFuture = null;
        }
    }

    @Override
    public void bridge$setUnresolvedPlayerProfile(@org.checkerframework.checker.nullness.qual.Nullable com.mojang.authlib.GameProfile owner) {
        this.cancelResolveFuture();
        this.shadow$setOwner(owner);
        this.impl$markDirtyAndUpdate();
    }

    @Redirect(method={"updateOwnerProfile()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/SkullBlockEntity;updateGameprofile(Lcom/mojang/authlib/GameProfile;)Lcom/mojang/authlib/GameProfile;"))
    private com.mojang.authlib.GameProfile onUpdateProfile(com.mojang.authlib.GameProfile input) {
        this.cancelResolveFuture();
        if (input == null) {
            return null;
        }
        if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
            return input;
        }
        GameProfileManager manager = Sponge.server().gameProfileManager();
        CompletableFuture<GameProfile> future = null;
        if (input.getId() != null) {
            future = manager.profile(input.getId());
        } else if (!StringUtil.isNullOrEmpty((String)input.getName())) {
            future = manager.profile(input.getName());
        }
        if (future == null) {
            return input;
        }
        future.thenAcceptAsync(profile -> {
            this.owner = SpongeGameProfile.toMcProfile(profile);
            this.impl$markDirtyAndUpdate();
        }, (Executor)SpongeCommon.server());
        this.impl$currentProfileFuture = future;
        return input;
    }

    public void setRemoved() {
        super.setRemoved();
        this.cancelResolveFuture();
    }

    private void impl$markDirtyAndUpdate() {
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            ((ServerLevel)this.level).getChunkSource().blockChanged(this.getBlockPos());
        }
    }
}

