/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.chunk.storage;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.IOWorker;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.chunk.ChunkEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.level.chunk.storage.IOWorkerBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={IOWorker.class})
public abstract class IOWorkerMixin
implements IOWorkerBridge {
    private @MonotonicNonNull ResourceKey<Level> impl$dimension;

    @Override
    public void bridge$setDimension(ResourceKey<Level> dimension) {
        this.impl$dimension = dimension;
    }

    @Inject(method={"runStore"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Ljava/util/concurrent/CompletableFuture;complete(Ljava/lang/Object;)Z")})
    private void impl$onSaved(ChunkPos param0, @Coerce Object param1, CallbackInfo ci) {
        if (this.impl$dimension == null) {
            return;
        }
        if (ShouldFire.CHUNK_EVENT_SAVE_POST) {
            Vector3i chunkPos = new Vector3i(param0.x, 0, param0.z);
            ChunkEvent.Save.Post postSave = SpongeEventFactory.createChunkEventSavePost(PhaseTracker.getInstance().currentCause(), chunkPos, (org.spongepowered.api.ResourceKey)this.impl$dimension.location());
            SpongeCommon.post(postSave);
        }
    }
}

