/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.entity;

import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.entity.ChangeEntityEquipmentEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.comp.EquipmentInventoryLens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin_Inventory
extends Entity {
    @Shadow
    public abstract void shadow$setItemSlot(EquipmentSlot var1, ItemStack var2);

    @Shadow
    protected abstract ItemStack shadow$getLastHandItem(EquipmentSlot var1);

    @Shadow
    protected abstract ItemStack shadow$getLastArmorItem(EquipmentSlot var1);

    @Shadow
    protected abstract void shadow$completeUsingItem();

    protected LivingEntityMixin_Inventory(EntityType<?> param0, Level param1) {
        super(param0, param1);
    }

    @Inject(method={"handleHandSwap"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerChunkCache;broadcast(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/network/protocol/Packet;)V")})
    protected void inventory$onHandleHandSwap(Map<EquipmentSlot, ItemStack> map, CallbackInfo ci) {
        Slot mainHand = this.impl$getSpongeSlot(EquipmentSlot.MAINHAND);
        boolean customMainHand = this.impl$throwEquipmentEvent(EquipmentSlot.MAINHAND, mainHand, map.get(EquipmentSlot.MAINHAND), this.shadow$getLastHandItem(EquipmentSlot.MAINHAND));
        Slot offHand = this.impl$getSpongeSlot(EquipmentSlot.OFFHAND);
        boolean customOffHand = this.impl$throwEquipmentEvent(EquipmentSlot.OFFHAND, offHand, map.get(EquipmentSlot.OFFHAND), this.shadow$getLastHandItem(EquipmentSlot.OFFHAND));
        if (customMainHand || customOffHand) {
            ci.cancel();
        }
    }

    @Inject(method={"handleEquipmentChanges"}, at={@At(value="INVOKE", remap=false, target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V")})
    protected void inventory$onHandleEquipmentChanges(Map<EquipmentSlot, ItemStack> map, CallbackInfo ci) {
        map.entrySet().forEach(entry -> {
            Slot slotAdapter = this.impl$getSpongeSlot((EquipmentSlot)entry.getKey());
            ItemStack oldStack = null;
            switch (((EquipmentSlot)entry.getKey()).getType()) {
                case HAND: {
                    oldStack = this.shadow$getLastHandItem((EquipmentSlot)entry.getKey());
                    break;
                }
                case ARMOR: {
                    oldStack = this.shadow$getLastArmorItem((EquipmentSlot)entry.getKey());
                }
            }
            entry.setValue(this.impl$callEquipmentEvent((EquipmentSlot)entry.getKey(), slotAdapter, (ItemStack)entry.getValue(), oldStack));
        });
    }

    @Redirect(method={"updatingUsingItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;completeUsingItem()V"))
    protected void inventory$onUpdateUsingItem(LivingEntity thisEntity) {
        this.shadow$completeUsingItem();
    }

    private ItemStack impl$callEquipmentEvent(EquipmentSlot equipmentslottype, Slot slot, ItemStack newStack, ItemStack oldStack) {
        ChangeEntityEquipmentEvent event = InventoryEventFactory.callChangeEntityEquipmentEvent((LivingEntity)this, ItemStackUtil.snapshotOf(oldStack), ItemStackUtil.snapshotOf(newStack), slot);
        if (event.isCancelled()) {
            this.shadow$setItemSlot(equipmentslottype, oldStack);
            return oldStack;
        }
        Transaction<@NonNull ItemStackSnapshot> transaction = event.transaction();
        if (!transaction.isValid()) {
            this.shadow$setItemSlot(equipmentslottype, oldStack);
            return oldStack;
        }
        Optional<ItemStackSnapshot> optional = transaction.custom();
        if (optional.isPresent()) {
            ItemStack custom = ItemStackUtil.fromSnapshotToNative(optional.get());
            this.shadow$setItemSlot(equipmentslottype, custom);
            return custom;
        }
        return newStack;
    }

    private boolean impl$throwEquipmentEvent(EquipmentSlot equipmentslottype, Slot slot, ItemStack newStack, ItemStack oldStack) {
        ChangeEntityEquipmentEvent event = InventoryEventFactory.callChangeEntityEquipmentEvent((LivingEntity)this, ItemStackUtil.snapshotOf(oldStack), ItemStackUtil.snapshotOf(newStack), slot);
        if (event.isCancelled()) {
            this.shadow$setItemSlot(equipmentslottype, oldStack);
            return true;
        }
        Transaction<@NonNull ItemStackSnapshot> transaction = event.transaction();
        if (!transaction.isValid()) {
            this.shadow$setItemSlot(equipmentslottype, oldStack);
            return true;
        }
        Optional<ItemStackSnapshot> optional = transaction.custom();
        if (optional.isPresent()) {
            ItemStack custom = ItemStackUtil.fromSnapshotToNative(optional.get());
            this.shadow$setItemSlot(equipmentslottype, custom);
            return true;
        }
        return false;
    }

    protected Slot impl$getSpongeSlot(EquipmentSlot equipmentSlot) {
        EquipmentType equipmentType = (EquipmentType)equipmentSlot;
        if (this instanceof InventoryBridge) {
            InventoryAdapter adapter = ((InventoryBridge)((Object)this)).bridge$getAdapter();
            Lens lens = adapter.inventoryAdapter$getRootLens();
            if (lens instanceof EquipmentInventoryLens) {
                SlotLens slotLens = ((EquipmentInventoryLens)lens).getSlotLens(equipmentType);
                return slotLens.getAdapter(adapter.inventoryAdapter$getFabric(), (Inventory)((Object)adapter));
            }
            throw new IllegalStateException("Expected EquipmentInventoryLens for " + ((Object)((Object)this)).getClass().getName() + " Inventory but found: " + lens.getClass().getName());
        }
        throw new IllegalStateException("Living Entity has no InventoryAdapter: " + ((Object)((Object)this)).getClass().getName());
    }
}

