/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.realtime.world.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.common.bridge.RealTimeTrackingBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;

@Mixin(value={Entity.class})
public abstract class EntityMixin_RealTime {
    @Shadow
    protected int boardingCooldown;
    @Shadow
    public Level level;
    @Shadow
    protected int portalTime;
    @Shadow
    private int portalCooldown;

    @Redirect(method={"baseTick"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/Entity;boardingCooldown:I", opcode=181), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;stopRiding()V"), to=@At(value="FIELD", target="Lnet/minecraft/world/entity/Entity;walkDist:F", opcode=180)))
    private void realTimeImpl$adjustForRealTimeEntityCooldown(Entity self, int modifier) {
        if (((LevelBridge)this.level).bridge$isFake()) {
            this.boardingCooldown = modifier;
            return;
        }
        int ticks = (int)((RealTimeTrackingBridge)this.level).realTimeBridge$getRealTimeTicks();
        this.boardingCooldown = Math.max(0, this.boardingCooldown - ticks);
    }

    @Redirect(method={"handleNetherPortal"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/Entity;portalTime:I", opcode=181, ordinal=0), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getPortalWaitTime()I"), to=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setPortalCooldown()V")))
    private void realTimeImpl$adjustForRealTimePortalCounter(Entity self, int modifier) {
        if (((LevelBridge)this.level).bridge$isFake()) {
            this.portalTime = modifier;
            return;
        }
        int ticks = (int)((RealTimeTrackingBridge)this.level).realTimeBridge$getRealTimeTicks();
        this.portalTime += ticks;
    }
}

