/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server.level;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.server.level.ServerPlayerGameModeBridge;
import org.spongepowered.common.bridge.world.inventory.container.ContainerBridge;
import org.spongepowered.common.bridge.world.item.ItemStackBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={ServerPlayerGameMode.class})
public abstract class ServerPlayerGameModeMixin_Tracker {
    @Shadow
    private GameType gameModeForPlayer;

    @Shadow
    public abstract boolean isCreative();

    @Inject(method={"useItem"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemCooldowns;isOnCooldown(Lnet/minecraft/world/item/Item;)Z")})
    public void impl$callInteractItemSecondary(ServerPlayer player, Level level, ItemStack stack, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        InteractItemEvent.Secondary event = SpongeCommonEventFactory.callInteractItemEventSecondary((Player)player, stack, hand);
        if (event.isCancelled()) {
            player.refreshContainer((AbstractContainerMenu)player.inventoryMenu);
            cir.setReturnValue((Object)InteractionResult.FAIL);
        }
    }

    @Overwrite
    public InteractionResult useItemOn(ServerPlayer playerIn, Level worldIn, ItemStack stackIn, InteractionHand handIn, BlockHitResult blockHitResultIn) {
        InteractionResult interactionResult;
        InteractBlockEvent.Secondary event;
        BlockPos blockPos = blockHitResultIn.getBlockPos();
        BlockState blockState = worldIn.getBlockState(blockPos);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            event = SpongeCommonEventFactory.createInteractBlockEventSecondary((Player)playerIn, (ServerLevel)worldIn, stackIn, handIn, blockHitResultIn, frame);
            SpongeCommon.post(event);
        }
        Tristate useItem = event.useItemResult();
        Tristate useBlock = event.useBlockResult();
        ((ServerPlayerGameModeBridge)((Object)this)).bridge$setInteractBlockRightClickCancelled(event.isCancelled());
        if (event.isCancelled()) {
            return InteractionResult.FAIL;
        }
        if (this.gameModeForPlayer == GameType.SPECTATOR) {
            MenuProvider menuProvider = blockState.getMenuProvider(worldIn, blockPos);
            if (menuProvider != null) {
                playerIn.openMenu(menuProvider);
                Vector3i pos = VecHelper.toVector3i(blockHitResultIn.getBlockPos());
                ServerLocation location = ServerLocation.of((ServerWorld)worldIn, pos);
                try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                    frame.pushCause(playerIn);
                    frame.addContext(EventContextKeys.BLOCK_HIT, ((ServerWorld)worldIn).createSnapshot(pos));
                    ((ContainerBridge)playerIn.containerMenu).bridge$setOpenLocation(location);
                    if (!InventoryEventFactory.callInteractContainerOpenEvent(playerIn)) {
                        InteractionResult interactionResult2 = InteractionResult.SUCCESS;
                        return interactionResult2;
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        UseOnContext useOnContext = new UseOnContext((Player)playerIn, handIn, blockHitResultIn);
        if (useItem != Tristate.FALSE && (interactionResult = ((ItemStackBridge)stackIn).bridge$onItemUseFirst(useOnContext)) != InteractionResult.PASS) {
            return interactionResult;
        }
        boolean hasItemInAnyHand = !playerIn.getMainHandItem().isEmpty() || !playerIn.getOffhandItem().isEmpty();
        boolean sneakUse = playerIn.isSecondaryUseActive() && hasItemInAnyHand && (!((ItemStackBridge)playerIn.getMainHandItem()).bridge$doesSneakBypassUse((LevelReader)worldIn, blockPos, (Player)playerIn) || !((ItemStackBridge)playerIn.getOffhandItem()).bridge$doesSneakBypassUse((LevelReader)worldIn, blockPos, (Player)playerIn));
        ItemStack copiedStack = stackIn.copy();
        if (useBlock != Tristate.FALSE && !sneakUse) {
            AbstractContainerMenu lastOpenContainer = playerIn.containerMenu;
            InteractionResult result = blockState.use(worldIn, (Player)playerIn, handIn, blockHitResultIn);
            if (result.consumesAction() && lastOpenContainer != playerIn.containerMenu) {
                Vector3i pos = VecHelper.toVector3i(blockHitResultIn.getBlockPos());
                ServerLocation location = ServerLocation.of((ServerWorld)worldIn, pos);
                try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                    frame.pushCause(playerIn);
                    frame.addContext(EventContextKeys.BLOCK_HIT, ((ServerWorld)worldIn).createSnapshot(pos));
                    ((ContainerBridge)playerIn.containerMenu).bridge$setOpenLocation(location);
                    if (!InventoryEventFactory.callInteractContainerOpenEvent(playerIn)) {
                        InteractionResult interactionResult3 = InteractionResult.FAIL;
                        return interactionResult3;
                    }
                }
            }
            if (result.consumesAction()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(playerIn, blockPos, copiedStack);
                return result;
            }
        }
        if (!stackIn.isEmpty() && !playerIn.getCooldowns().isOnCooldown(stackIn.getItem())) {
            InteractionResult result;
            if (useItem == Tristate.FALSE) {
                ((ServerPlayerGameModeBridge)((Object)this)).bridge$setInteractBlockRightClickCancelled(true);
                return InteractionResult.PASS;
            }
            if (this.isCreative()) {
                int i = stackIn.getCount();
                result = stackIn.useOn(useOnContext);
                stackIn.setCount(i);
            } else {
                result = stackIn.useOn(useOnContext);
                PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
                TransactionalCaptureSupplier transactor = context.getTransactor();
                transactor.logPlayerInventoryChange((Player)playerIn, PlayerInventoryTransaction.EventCreator.STANDARD);
                playerIn.inventoryMenu.broadcastChanges();
            }
            if (result.consumesAction()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(playerIn, blockPos, copiedStack);
            }
            return result;
        }
        if (useBlock == Tristate.FALSE && !sneakUse) {
            ((ServerPlayerGameModeBridge)((Object)this)).bridge$setInteractBlockRightClickCancelled(true);
        }
        return InteractionResult.PASS;
    }
}

