/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryPacket;
import net.minecraft.resources.ResourceLocation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.common.accessor.network.protocol.game.ClientboundCustomPayloadPacketAccessor;
import org.spongepowered.common.accessor.network.protocol.game.ServerboundCustomPayloadPacketAccessor;
import org.spongepowered.common.accessor.network.protocol.login.ClientboundCustomQueryPacketAccessor;
import org.spongepowered.common.accessor.network.protocol.login.ServerboundCustomQueryPacketAccessor;

public final class PacketUtil {
    public static Packet<?> createLoginPayloadResponse(@Nullable ChannelBuf payload, int transactionId) {
        ServerboundCustomQueryPacket packet = new ServerboundCustomQueryPacket();
        ServerboundCustomQueryPacketAccessor accessor = (ServerboundCustomQueryPacketAccessor)packet;
        accessor.accessor$transactionId(transactionId);
        accessor.accessor$data((FriendlyByteBuf)payload);
        return packet;
    }

    public static Packet<?> createLoginPayloadRequest(ResourceKey channel, ChannelBuf payload, int transactionId) {
        ClientboundCustomQueryPacket packet = new ClientboundCustomQueryPacket();
        ClientboundCustomQueryPacketAccessor accessor = (ClientboundCustomQueryPacketAccessor)packet;
        accessor.accessor$identifier((ResourceLocation)channel);
        accessor.accessor$transactionId(transactionId);
        accessor.accessor$data((FriendlyByteBuf)payload);
        return packet;
    }

    public static Packet<?> createPlayPayload(ResourceKey channel, ChannelBuf payload, EngineConnectionSide<?> side) {
        if (side == EngineConnectionSide.CLIENT) {
            ServerboundCustomPayloadPacketAccessor packet = (ServerboundCustomPayloadPacketAccessor)new ServerboundCustomPayloadPacket();
            packet.accessor$identifier((ResourceLocation)channel);
            packet.accessor$data((FriendlyByteBuf)payload);
            return (Packet)packet;
        }
        if (side == EngineConnectionSide.SERVER) {
            ClientboundCustomPayloadPacketAccessor packet = (ClientboundCustomPayloadPacketAccessor)new ClientboundCustomPayloadPacket();
            packet.accessor$identifier((ResourceLocation)channel);
            packet.accessor$data((FriendlyByteBuf)payload);
            return (Packet)packet;
        }
        throw new UnsupportedOperationException();
    }

    public static <P extends org.spongepowered.api.network.channel.packet.Packet> Supplier<P> getConstructor(Class<P> packetClass) {
        Constructor constructor;
        try {
            constructor = packetClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        return () -> {
            try {
                return (org.spongepowered.api.network.channel.packet.Packet)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        };
    }

    private PacketUtil() {
    }
}

