/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.server;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.registry.RegistryKey;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.difficulty.Difficulty;

public final class BootstrapProperties {
    public static WorldGenSettings worldGenSettings;
    public static RegistryReference<GameMode> gameMode;
    public static RegistryReference<Difficulty> difficulty;
    public static SerializationBehavior serializationBehavior;
    public static boolean pvp;
    public static boolean hardcore;
    public static boolean commands;
    public static int viewDistance;
    public static RegistryAccess registries;
    public static RegistryReadOps<?> worldSettingsAdapter;
    public static boolean isNewLevel;

    public static void init(WorldGenSettings worldGenSettings, GameType gameType, net.minecraft.world.Difficulty difficulty, boolean pvp, boolean hardcore, boolean commands, int viewDistance, RegistryAccess registries) {
        BootstrapProperties.worldGenSettings = worldGenSettings;
        gameMode = RegistryKey.of(RegistryTypes.GAME_MODE, ResourceKey.sponge(gameType.getName())).asDefaultedReference(Sponge::game);
        BootstrapProperties.difficulty = RegistryKey.of(RegistryTypes.DIFFICULTY, ResourceKey.sponge(difficulty.getKey())).asDefaultedReference(Sponge::game);
        BootstrapProperties.pvp = pvp;
        BootstrapProperties.hardcore = hardcore;
        BootstrapProperties.commands = commands;
        BootstrapProperties.viewDistance = viewDistance;
        BootstrapProperties.registries = registries;
        serializationBehavior = SerializationBehavior.AUTOMATIC;
    }

    public static <T> void worldSettingsAdapter(RegistryReadOps<T> worldSettingsAdapter) {
        BootstrapProperties.worldSettingsAdapter = worldSettingsAdapter;
    }

    public static void setIsNewLevel(boolean isNewLevel) {
        BootstrapProperties.isNewLevel = isNewLevel;
    }

    static {
        viewDistance = 10;
        isNewLevel = false;
    }
}

