/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.server;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;

public final class PerWorldBorderListener
implements BorderChangeListener {
    private final ServerLevel world;

    public PerWorldBorderListener(ServerLevel world) {
        this.world = world;
    }

    public void onBorderSizeSet(WorldBorder border, double newSize) {
        this.sendWorldBorderActionPacket(border, ClientboundSetBorderPacket.Type.SET_SIZE);
    }

    public void onBorderSizeLerping(WorldBorder border, double oldSize, double newSize, long time) {
        this.sendWorldBorderActionPacket(border, ClientboundSetBorderPacket.Type.LERP_SIZE);
    }

    public void onBorderCenterSet(WorldBorder border, double x, double z) {
        this.sendWorldBorderActionPacket(border, ClientboundSetBorderPacket.Type.SET_CENTER);
    }

    public void onBorderSetWarningTime(WorldBorder border, int newTime) {
        this.sendWorldBorderActionPacket(border, ClientboundSetBorderPacket.Type.SET_WARNING_TIME);
    }

    public void onBorderSetWarningBlocks(WorldBorder border, int newDistance) {
        this.sendWorldBorderActionPacket(border, ClientboundSetBorderPacket.Type.SET_WARNING_BLOCKS);
    }

    public void onBorderSetDamagePerBlock(WorldBorder border, double newAmount) {
    }

    public void onBorderSetDamageSafeZOne(WorldBorder border, double newSize) {
    }

    private void sendWorldBorderActionPacket(WorldBorder border, ClientboundSetBorderPacket.Type action) {
        ClientboundSetBorderPacket packet = new ClientboundSetBorderPacket(border, action);
        this.world.players().forEach(player -> player.connection.send((Packet)packet));
    }
}

