/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.transformation;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.util.rotation.Rotation;
import org.spongepowered.api.util.rotation.Rotations;
import org.spongepowered.api.util.transformation.Transformation;
import org.spongepowered.common.util.transformation.SpongeTransformation;
import org.spongepowered.math.matrix.Matrix4d;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector4d;

public final class SpongeTransformationBuilder
implements Transformation.Builder {
    private Vector3d origin;
    private Matrix4d transformation;
    private Matrix4d directionTransformation;
    private boolean performRounding;
    private @Nullable Rotation rotation;
    private boolean flipx;
    private boolean flipz;

    public SpongeTransformationBuilder() {
        this.reset();
    }

    SpongeTransformationBuilder(SpongeTransformation transformation) {
        this.reset();
        this.origin = transformation.origin;
        Matrix4d partialRotation = this.transformation.translate(this.origin.mul(-1.0f));
        Matrix4d invertedMatrix = Matrix4d.createTranslation((Vector3d)this.origin);
        this.transformation = partialRotation.mul(invertedMatrix);
        this.directionTransformation = transformation.directionTransformation;
        this.flipx = transformation.flipx;
        this.flipz = transformation.flipz;
        this.rotation = transformation.rotation;
        this.performRounding = transformation.performRounding;
    }

    @Override
    public @NonNull SpongeTransformationBuilder reset() {
        this.transformation = Matrix4d.IDENTITY;
        this.directionTransformation = Matrix4d.IDENTITY;
        this.origin = Vector3d.ZERO;
        this.performRounding = true;
        this.rotation = null;
        this.flipx = false;
        this.flipz = false;
        return this;
    }

    @Override
    public @NonNull SpongeTransformationBuilder origin(@NonNull Vector3d origin) {
        this.origin = origin;
        return this;
    }

    @Override
    public @NonNull SpongeTransformationBuilder rotate(@NonNull Rotation rotation) {
        Matrix4d rotationMatrix = rotation.toRotationMatrix();
        this.transformation = rotationMatrix.mul(this.transformation);
        this.directionTransformation = rotationMatrix.mul(this.directionTransformation);
        this.rotation = this.rotation == null ? rotation : this.rotation.and(rotation);
        if (this.flipx ^ this.flipz && rotation.angle().degrees() % 180.0 == 90.0) {
            this.flipz = this.flipx;
            this.flipx = !this.flipx;
        }
        return this;
    }

    @Override
    public @NonNull SpongeTransformationBuilder mirror(@NonNull Axis axis) {
        if (Objects.requireNonNull(axis) == Axis.Y) {
            throw new IllegalArgumentException("The Y direction cannot be mirrored.");
        }
        Vector4d scale = Vector4d.ONE.sub(axis.toVector3d().toVector4(0.0f).mul(2.0f));
        this.transformation = this.transformation.scale(scale);
        this.directionTransformation = this.directionTransformation.scale(scale);
        this.flipx ^= axis == Axis.X;
        this.flipz ^= axis == Axis.Z;
        return this;
    }

    @Override
    public @NonNull SpongeTransformationBuilder translate(@NonNull Vector3d translate) {
        this.transformation = this.transformation.translate(translate);
        return this;
    }

    @Override
    public @NonNull SpongeTransformationBuilder performRounding(boolean round) {
        this.performRounding = round;
        return this;
    }

    @Override
    public @NonNull SpongeTransformation build() {
        Matrix4d partialRotation = this.transformation.translate(this.origin);
        Matrix4d invertedMatrix = Matrix4d.createTranslation((Vector3d)this.origin.mul(-1.0f));
        Matrix4d rotatedAroundOrigin = partialRotation.mul(invertedMatrix);
        SpongeTransformation transformation = new SpongeTransformation(this.origin, rotatedAroundOrigin, this.directionTransformation, this.performRounding, this.rotation == null ? Rotations.NONE.get() : this.rotation, this.flipx, this.flipz);
        this.reset();
        return transformation;
    }
}

