/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.weather;

import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.WeatherType;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.weather.SpongeWeatherType;

public final class SpongeWeather
implements Weather {
    private final SpongeWeatherType type;
    private final Ticks remainingDuration;
    private final Ticks runningDuration;

    public SpongeWeather(SpongeWeatherType type, Ticks remainingDuration, Ticks runningDuration) {
        this.type = type;
        this.remainingDuration = remainingDuration;
        this.runningDuration = runningDuration;
    }

    @Override
    public WeatherType type() {
        return this.type;
    }

    @Override
    public Ticks remainingDuration() {
        return this.remainingDuration;
    }

    @Override
    public Ticks runningDuration() {
        return this.runningDuration;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.Universe.Weather.TYPE, this.type.key(RegistryTypes.WEATHER_TYPE)).set(Constants.Universe.Weather.REMAINING_DURATION, this.remainingDuration.ticks()).set(Constants.Universe.Weather.RUNNING_DURATION, this.runningDuration.ticks());
    }

    public static class FactoryImpl
    implements Weather.Factory {
        @Override
        public Weather of(WeatherType type, Ticks remainingDuration, Ticks runningDuration) {
            return new SpongeWeather((SpongeWeatherType)type, remainingDuration, runningDuration);
        }
    }
}

