/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import net.minecraftforge.fart.api.Renamer;
import net.minecraftforge.fart.api.SignatureStripperConfig;
import net.minecraftforge.fart.api.SourceFixerConfig;
import net.minecraftforge.fart.api.Transformer;
import net.minecraftforge.srgutils.IMappingFile;
import org.spongepowered.vanilla.installer.Agent;
import org.spongepowered.vanilla.installer.AsyncUtils;
import org.spongepowered.vanilla.installer.Installer;
import org.spongepowered.vanilla.installer.InstallerUtils;
import org.spongepowered.vanilla.installer.LauncherCommandLine;
import org.spongepowered.vanilla.installer.LibraryManager;
import org.spongepowered.vanilla.installer.model.mojang.Version;
import org.spongepowered.vanilla.installer.model.mojang.VersionManifest;
import org.tinylog.Logger;

public final class InstallerMain {
    private static final String COLLECTION_BOOTSTRAP = "bootstrap";
    private static final String COLLECTION_MAIN = "main";
    private static final int MAX_TRIES = 2;
    private final Installer installer;

    public InstallerMain(String[] args) throws Exception {
        LauncherCommandLine.configure(args);
        this.installer = new Installer(LauncherCommandLine.installerDirectory);
    }

    public static void main(String[] args) throws Exception {
        new InstallerMain(args).run();
    }

    public void run() {
        try {
            this.downloadAndRun();
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex, "Failed to download Sponge libraries and/or Minecraft");
            System.exit(2);
        }
        finally {
            this.installer.getLibraryManager().finishedProcessing();
        }
    }

    public void downloadAndRun() throws Exception {
        Path remappedMinecraftJar = null;
        Version mcVersion = null;
        try {
            mcVersion = this.downloadMinecraftManifest();
        }
        catch (IOException ex) {
            remappedMinecraftJar = this.recoverFromMinecraftDownloadError(ex);
            this.installer.getLibraryManager().validate();
        }
        try {
            if (mcVersion != null) {
                CompletableFuture<Path> mappingsFuture = this.downloadMappings(mcVersion, LauncherCommandLine.librariesDirectory);
                CompletableFuture<Path> originalMcFuture = this.downloadMinecraft(mcVersion, LauncherCommandLine.librariesDirectory);
                CompletionStage remappedMinecraftJarFuture = mappingsFuture.thenCombineAsync(originalMcFuture, (mappings, minecraft) -> {
                    try {
                        return this.remapMinecraft((Path)minecraft, (Path)mappings, this.installer.getLibraryManager().preparationWorker());
                    }
                    catch (IOException ex) {
                        return (Path)AsyncUtils.sneakyThrow(ex);
                    }
                }, (Executor)this.installer.getLibraryManager().preparationWorker());
                this.installer.getLibraryManager().validate();
                remappedMinecraftJar = (Path)((CompletableFuture)remappedMinecraftJarFuture).get();
            }
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            remappedMinecraftJar = this.recoverFromMinecraftDownloadError(cause instanceof Exception ? (Exception)cause : ex);
        }
        assert (remappedMinecraftJar != null);
        this.installer.getLibraryManager().addLibrary(COLLECTION_BOOTSTRAP, new LibraryManager.Library("minecraft", remappedMinecraftJar));
        this.installer.getLibraryManager().finishedProcessing();
        Logger.info("Environment has been verified.");
        this.installer.getLibraryManager().getAll(COLLECTION_BOOTSTRAP).stream().map(LibraryManager.Library::getFile).forEach(path -> {
            Logger.debug("Adding jar {} to classpath", path);
            Agent.addJarToClasspath(path);
        });
        Path[] transformableLibs = (Path[])this.installer.getLibraryManager().getAll(COLLECTION_MAIN).stream().map(LibraryManager.Library::getFile).toArray(Path[]::new);
        ArrayList<String> gameArgs = new ArrayList<String>(LauncherCommandLine.remainingArgs);
        Collections.addAll(gameArgs, this.installer.getLauncherConfig().args.split(" "));
        Agent.crackModules();
        String className = "org.spongepowered.vanilla.applaunch.Main";
        InstallerMain.invokeMain("org.spongepowered.vanilla.applaunch.Main", gameArgs.toArray(new String[0]), transformableLibs);
    }

    private <T extends Throwable> Path recoverFromMinecraftDownloadError(T ex) throws T {
        Path expectedMinecraftJar = this.expectedRemappedLocation(this.expectedMinecraftLocation(LauncherCommandLine.librariesDirectory, "1.16.5"));
        if (Files.exists(expectedMinecraftJar, new LinkOption[0])) {
            Logger.warn(ex, "Failed to download and remap Minecraft. An existing jar exists, so we will attempt to use that instead.");
            return expectedMinecraftJar;
        }
        throw ex;
    }

    private static void invokeMain(String className, String[] args, Path[] extraCpEntries) {
        try {
            Class.forName(className).getMethod(COLLECTION_MAIN, String[].class, Path[].class).invoke(null, args, extraCpEntries);
        }
        catch (InvocationTargetException ex) {
            Logger.error(ex.getCause(), "Failed to invoke main class {} due to an error", className);
            System.exit(1);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException ex) {
            Logger.error((Throwable)ex, "Failed to invoke main class {} due to an error", className);
            System.exit(1);
        }
    }

    private Version downloadMinecraftManifest() throws IOException {
        Version version;
        Logger.info("Downloading the Minecraft versions manifest...");
        VersionManifest.Version foundVersionManifest = null;
        Gson gson = new Gson();
        URLConnection conn = new URL("https://launchermeta.mojang.com/mc/game/version_manifest.json").openConnection();
        conn.setConnectTimeout(5000);
        try (JsonReader reader = new JsonReader(new InputStreamReader(conn.getInputStream()));){
            VersionManifest manifest = (VersionManifest)gson.fromJson(reader, (Type)((Object)VersionManifest.class));
            for (VersionManifest.Version version2 : manifest.versions) {
                if (!"1.16.5".equals(version2.id)) continue;
                foundVersionManifest = version2;
                break;
            }
        }
        if (foundVersionManifest == null) {
            throw new IOException(String.format("Failed to find version manifest for '%s'!", "1.16.5"));
        }
        try (JsonReader reader = new JsonReader(new InputStreamReader(foundVersionManifest.url.openStream()));){
            version = (Version)gson.fromJson(reader, (Type)((Object)Version.class));
        }
        if (version == null) {
            throw new IOException(String.format("Failed to download version information for '%s'!", "1.16.5"));
        }
        return version;
    }

    private Path expectedMinecraftLocation(Path librariesDirectory, String version) {
        return librariesDirectory.resolve("net/minecraft").resolve(version).resolve("minecraft_server.jar");
    }

    private Path expectedRemappedLocation(Path originalLocation) {
        return originalLocation.resolveSibling("minecraft_server_remapped.jar");
    }

    private CompletableFuture<Path> downloadMinecraft(Version version, Path librariesDirectory) {
        return AsyncUtils.asyncFailableFuture(() -> {
            Path downloadTarget = this.expectedMinecraftLocation(librariesDirectory, version.id);
            if (Files.notExists(downloadTarget, new LinkOption[0])) {
                if (!this.installer.getLauncherConfig().autoDownloadLibraries) {
                    throw new IOException(String.format("The Minecraft jar is not located at '%s' and downloading it has been turned off.", downloadTarget));
                }
                InstallerUtils.downloadCheckHash(version.downloads.server.url, downloadTarget, MessageDigest.getInstance("SHA-1"), version.downloads.server.sha1, false);
            } else if (this.installer.getLauncherConfig().checkLibraryHashes) {
                Logger.info("Detected existing Minecraft Server jar, verifying hashes...");
                if (InstallerUtils.validateSha1(version.downloads.server.sha1, downloadTarget)) {
                    Logger.info("Minecraft Server jar verified!");
                } else {
                    Logger.error("Checksum verification failed: Expected {}. Deleting cached Minecraft Server jar...", version.downloads.server.sha1);
                    Files.delete(downloadTarget);
                    InstallerUtils.downloadCheckHash(version.downloads.server.url, downloadTarget, MessageDigest.getInstance("SHA-1"), version.downloads.server.sha1, false);
                }
            } else {
                Logger.info("Detected existing Minecraft jar. Skipping hash check as that is turned off...");
            }
            return downloadTarget;
        }, this.installer.getLibraryManager().preparationWorker());
    }

    private CompletableFuture<Path> downloadMappings(Version version, Path librariesDirectory) {
        return AsyncUtils.asyncFailableFuture(() -> {
            Logger.info("Setting up names for Minecraft {}", "1.16.5");
            Path downloadTarget = librariesDirectory.resolve("net/minecraft/mappings").resolve("1.16.5").resolve("server.txt");
            Version.Downloads.Download mappings = version.downloads.server_mappings;
            if (mappings == null) {
                throw new IOException(String.format("Mappings were not included in version manifest for %s", "1.16.5"));
            }
            boolean checkHashes = this.installer.getLauncherConfig().checkLibraryHashes;
            if (Files.exists(downloadTarget, new LinkOption[0])) {
                if (checkHashes) {
                    Logger.info("Detected existing mappings, verifying hashes...");
                    if (InstallerUtils.validateSha1(mappings.sha1, downloadTarget)) {
                        Logger.info("Mappings verified!");
                        return downloadTarget;
                    }
                    Logger.error("Checksum verification failed: Expected {}. Deleting cached server mappings file...", version.downloads.server.sha1);
                    Files.delete(downloadTarget);
                } else {
                    return downloadTarget;
                }
            }
            if (this.installer.getLauncherConfig().autoDownloadLibraries) {
                if (checkHashes) {
                    InstallerUtils.downloadCheckHash(mappings.url, downloadTarget, MessageDigest.getInstance("SHA-1"), mappings.sha1, false);
                } else {
                    InstallerUtils.download(mappings.url, downloadTarget, false);
                }
            } else {
                throw new IOException(String.format("Mappings were not located at '%s' and downloading them has been turned off.", downloadTarget));
            }
            return downloadTarget;
        }, this.installer.getLibraryManager().preparationWorker());
    }

    private Path remapMinecraft(Path inputJar, Path serverMappings, ExecutorService service) throws IOException {
        Logger.info("Checking if we need to remap Minecraft...");
        Path outputJar = this.expectedRemappedLocation(inputJar);
        Path tempOutput = outputJar.resolveSibling("minecraft_server_remapped.jar.tmp");
        if (Files.exists(outputJar, new LinkOption[0])) {
            Logger.info("Remapped Minecraft detected, skipping...");
            return outputJar;
        }
        Logger.info("Remapping Minecraft. This may take a while...");
        IMappingFile mappings = IMappingFile.load(serverMappings.toFile()).reverse();
        Renamer.builder().input(inputJar.toFile()).output(tempOutput.toFile()).add(Transformer.parameterAnnotationFixerFactory()).add(ctx -> {
            final Transformer backing = Transformer.renamerFactory(mappings).create(ctx);
            return new Transformer(){

                @Override
                public Transformer.ClassEntry process(Transformer.ClassEntry entry) {
                    String name = entry.getName();
                    if (name.startsWith("it/unimi") || name.startsWith("com/google") || name.startsWith("com/mojang/datafixers") || name.startsWith("com/mojang/brigadier") || name.startsWith("org/apache")) {
                        return entry;
                    }
                    return backing.process(entry);
                }

                @Override
                public Transformer.ManifestEntry process(Transformer.ManifestEntry entry) {
                    return backing.process(entry);
                }

                @Override
                public Transformer.ResourceEntry process(Transformer.ResourceEntry entry) {
                    return backing.process(entry);
                }

                @Override
                public Collection<? extends Transformer.Entry> getExtras() {
                    return backing.getExtras();
                }
            };
        }).add(Transformer.recordFixerFactory()).add(Transformer.parameterAnnotationFixerFactory()).add(Transformer.sourceFixerFactory(SourceFixerConfig.JAVA)).add(Transformer.signatureStripperFactory(SignatureStripperConfig.ALL)).logger(Logger::debug).build().run();
        try {
            Files.move(tempOutput, outputJar, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AccessDeniedException ex) {
            for (int tries = 0; tries < 2; ++tries) {
                try {
                    Thread.sleep(5 * tries);
                    Files.move(tempOutput, outputJar, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                catch (AccessDeniedException ex2) {
                    if (tries != 1) continue;
                    throw ex;
                }
                catch (InterruptedException exInterrupt) {
                    Thread.currentThread().interrupt();
                    throw ex;
                }
            }
        }
        return outputJar;
    }
}

