/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.context;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.tree.CommandNode;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandSourceStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.Flag;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.service.permission.Subject;

public final class SpongeCommandContext
extends CommandContext<CommandSourceStack>
implements org.spongepowered.api.command.parameter.CommandContext {
    private final Map<Parameter.Key<?>, Collection<?>> argumentMap;
    private final Object2IntOpenHashMap<String> flagMap;
    private final Map<String, ParsedArgument<CommandSourceStack, ?>> brigArguments;
    private final  @Nullable Command.Parameterized targetCommand;

    public SpongeCommandContext(CommandSourceStack source, String input, Map<String, ParsedArgument<CommandSourceStack, ?>> brigArguments, Map<Parameter.Key<?>, Collection<?>> arguments, CommandNode<CommandSourceStack> rootNode, Object2IntOpenHashMap<String> flags, Command<CommandSourceStack> command, List<ParsedCommandNode<CommandSourceStack>> nodes, StringRange range, @Nullable CommandContext<CommandSourceStack> child, @Nullable RedirectModifier<CommandSourceStack> modifier, boolean forks,  @Nullable Command.Parameterized currentTargetCommand) {
        super((Object)source, input, brigArguments, command, rootNode, nodes, range, child, modifier, forks);
        this.brigArguments = brigArguments;
        this.argumentMap = arguments;
        this.flagMap = flags.clone();
        this.targetCommand = currentTargetCommand;
    }

    @Override
    public @NonNull Optional<Command.Parameterized> executedCommand() {
        return Optional.ofNullable(this.targetCommand);
    }

    @Override
    public @NonNull CommandCause cause() {
        return (CommandCause)this.getSource();
    }

    @Override
    public boolean hasFlag(@NonNull String flagAlias) {
        return this.flagMap.containsKey((Object)flagAlias);
    }

    @Override
    public boolean hasFlag(@NonNull Flag flag) {
        return this.flagMap.containsKey((Object)flag.unprefixedAliases().iterator().next());
    }

    @Override
    public int flagInvocationCount(@NonNull String flagKey) {
        return this.flagMap.getOrDefault((Object)flagKey, 0);
    }

    @Override
    public int flagInvocationCount(@NonNull Flag flag) {
        return this.flagMap.getOrDefault((Object)flag.unprefixedAliases().iterator().next(), 0);
    }

    @Override
    public boolean hasAny( @NonNull Parameter.Key<?> key) {
        Collection<?> value = this.argumentMap.get(key);
        if (value != null) {
            return !value.isEmpty();
        }
        return false;
    }

    @Override
    public <T> @NonNull Optional<T> one( @NonNull Parameter.Key<T> key) {
        return Optional.ofNullable(this.getValue(key));
    }

    @Override
    public <T> @NonNull T requireOne( @NonNull Parameter.Key<T> key) throws NoSuchElementException {
        T value = this.getValue(key);
        if (value == null) {
            throw new NoSuchElementException("No value exists for key " + key.key());
        }
        return value;
    }

    @Override
    public <T> @NonNull Collection<? extends T> all( @NonNull Parameter.Key<T> key) {
        Collection<?> values = this.argumentMap.get(key);
        if (values == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(values);
    }

    @Override
    public boolean hasAny(Parameter.Value<?> parameter) {
        return this.hasAny(parameter.key());
    }

    @Override
    public <T> Optional<T> one(Parameter.Value<T> parameter) throws IllegalArgumentException {
        return this.one(parameter.key());
    }

    @Override
    public <T> T requireOne(Parameter.Value<T> parameter) throws NoSuchElementException, IllegalArgumentException {
        return this.requireOne(parameter.key());
    }

    @Override
    public <T> Collection<? extends T> all(Parameter.Value<T> parameter) {
        return this.all(parameter.key());
    }

    @Override
    public void sendMessage(@NonNull Identified identity, @NonNull Component message) {
        this.cause().sendMessage(identity, message);
    }

    @Override
    public void sendMessage(@NonNull Identity identity, @NonNull Component message) {
        this.cause().sendMessage(identity, message);
    }

    public CommandContext<CommandSourceStack> copyFor(CommandSourceStack source) {
        if (this.getSource() == source) {
            return this;
        }
        return new SpongeCommandContext(source, this.getInput(), this.brigArguments, (Map<Parameter.Key<?>, Collection<?>>)ImmutableMap.copyOf(this.argumentMap), (CommandNode<CommandSourceStack>)this.getRootNode(), (Object2IntOpenHashMap<String>)this.flagMap.clone(), (Command<CommandSourceStack>)this.getCommand(), this.getNodes(), this.getRange(), (CommandContext<CommandSourceStack>)this.getChild(), (RedirectModifier<CommandSourceStack>)this.getRedirectModifier(), this.isForked(), this.targetCommand);
    }

    private <T> @Nullable T getValue(Parameter.Key<? super T> key) {
        Collection<?> values = this.argumentMap.get(key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values.size() != 1) {
            throw new IllegalArgumentException(values.size() + " values exist for key " + key.key() + " when requireOne was called.");
        }
        return (T)values.iterator().next();
    }

    @Override
    public Subject subject() {
        return this.cause().subject();
    }

    @Override
    public Cause contextCause() {
        return this.cause().cause();
    }
}

