/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import com.mojang.brigadier.arguments.ArgumentType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.common.command.SpongeCommandCompletion;
import org.spongepowered.common.command.brigadier.argument.AbstractArgumentParser;
import org.spongepowered.common.util.Constants;

public final class SpongeCatalogedElementValueParameter<T>
extends AbstractArgumentParser<T> {
    private final List<String> prefixes;
    private final List<Function<CommandContext, @Nullable RegistryHolder>> registryHolderFunctions;
    private final RegistryType<? extends T> registryType;

    public SpongeCatalogedElementValueParameter(List<String> prefixes, List<Function<CommandContext, @Nullable RegistryHolder>> registryFunctions, RegistryType<? extends T> registryType) {
        this.prefixes = prefixes;
        this.registryHolderFunctions = registryFunctions;
        this.registryType = registryType;
    }

    @Override
    public @NonNull Optional<? extends T> parseValue( @NonNull Parameter.Key<? super T> parameterKey,  @NonNull ArgumentReader.Mutable reader, @NonNull CommandContext.Builder context) throws ArgumentParseException {
        List<Registry<T>> registry = this.registryHolderFunctions.stream().map(x -> this.retrieveRegistry((Function<CommandContext, RegistryHolder>)x, context)).filter(Objects::nonNull).collect(Collectors.toList());
        if (registry.isEmpty()) {
            throw reader.createException((Component)Component.text((String)"No registries associated with this parameter are active."));
        }
        ArgumentReader.Immutable snapshot = reader.immutable();
        try {
            ResourceKey resourceKey = reader.parseResourceKey();
            Optional<T> result = this.selectValue(registry, resourceKey);
            if (!result.isPresent()) {
                throw reader.createException((Component)Component.text((String)("None of the selected registries contain the ID " + resourceKey.asString())));
            }
            return result;
        }
        catch (ArgumentParseException ex) {
            if (this.prefixes.isEmpty()) {
                throw ex;
            }
            reader.setState(snapshot);
            String check = reader.parseUnquotedString();
            for (String prefix : this.prefixes) {
                Optional<T> result = this.selectValue(registry, ResourceKey.of(prefix, check));
                if (!result.isPresent()) continue;
                return result;
            }
            String ids = this.prefixes.stream().map(x -> x + ":" + check).collect(Collectors.joining(", "));
            throw reader.createException((Component)Component.text((String)("None of the selected registries contain any of the following IDs: " + ids)));
        }
    }

    @Override
    public @NonNull List<CommandCompletion> complete(@NonNull CommandContext context, @NonNull String currentInput) {
        String lowerCase = currentInput.toLowerCase();
        return this.registryHolderFunctions.stream().map(x -> this.retrieveRegistry((Function<CommandContext, RegistryHolder>)x, context)).filter(Objects::nonNull).flatMap(Registry::streamEntries).map(RegistryEntry::key).map(x -> {
            if (x.asString().startsWith(lowerCase)) {
                return x.asString();
            }
            if (this.prefixes.contains(x.namespace()) && x.value().startsWith(lowerCase)) {
                return x.value();
            }
            return null;
        }).filter(Objects::nonNull).map(SpongeCommandCompletion::new).collect(Collectors.toList());
    }

    @Override
    public List<ArgumentType<?>> getClientCompletionArgumentType() {
        return Collections.singletonList(Constants.Command.RESOURCE_LOCATION_TYPE);
    }

    private Optional<? extends T> selectValue(List<Registry<? extends T>> registry, ResourceKey resourceKey) {
        return registry.stream().map(x -> x.findValue(resourceKey).orElse(null)).filter(Objects::nonNull).findFirst();
    }

    private @Nullable Registry<? extends T> retrieveRegistry(Function<CommandContext, @Nullable RegistryHolder> func, CommandContext context) {
        RegistryHolder holder = func.apply(context);
        if (holder != null) {
            return holder.findRegistry(this.registryType).orElse(null);
        }
        return null;
    }
}

