/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.datasync.entity;

import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.data.datasync.DataParameterConverter;

public final class EntityCustomNameConverter
extends DataParameterConverter<Component> {
    public EntityCustomNameConverter() {
        super(EntityAccessor.accessor$DATA_CUSTOM_NAME());
    }

    @Override
    public Optional<DataTransactionResult> createTransaction(Entity entity, Component oldValue, Component newValue) {
        return Optional.of(DataTransactionResult.builder().replace(Value.immutableOf(Keys.DISPLAY_NAME, SpongeAdventure.asAdventure(oldValue))).success(Value.immutableOf(Keys.DISPLAY_NAME, SpongeAdventure.asAdventure(newValue))).result(DataTransactionResult.Type.SUCCESS).build());
    }

    @Override
    public Component getValueFromEvent(Component oldValue, DataTransactionResult result) {
        return result.successfulValue(Keys.DISPLAY_NAME).map(v -> {
            try {
                return SpongeAdventure.asVanilla((net.kyori.adventure.text.Component)v.get());
            }
            catch (Exception ignored) {
                return oldValue;
            }
        }).orElse(oldValue);
    }
}

