/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class ExplodeBlockEffect
implements ProcessingSideEffect {
    public static ExplodeBlockEffect getInstance() {
        return Holder.INSTANCE;
    }

    ExplodeBlockEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        PhaseContext<@NonNull ?> phaseContext = PhaseTracker.getInstance().getPhaseContext();
        ServerLevel world = pipeline.getServerWorld();
        BlockPos pos = oldState.pos;
        if (phaseContext instanceof ExplosionContext) {
            oldState.state.getBlock().wasExploded((Level)world, pos, ((ExplosionContext)phaseContext).getExplosion());
        }
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final ExplodeBlockEffect INSTANCE = new ExplodeBlockEffect();

        private Holder() {
        }
    }
}

