/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl.comp;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.inventory.adapter.impl.comp.GridInventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.comp.Inventory2DLens;
import org.spongepowered.common.inventory.lens.impl.comp.InventoryColumnLens;
import org.spongepowered.common.inventory.lens.impl.comp.InventoryRowLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.property.KeyValuePair;

public class GridInventoryLens
extends Inventory2DLens {
    private List<Lens> rows = new ArrayList<Lens>();
    private List<Lens> cols = new ArrayList<Lens>();

    public GridInventoryLens(int base, int width, int height, SlotLensProvider slots) {
        this(base, width, height, GridInventoryAdapter.class, slots);
    }

    public GridInventoryLens(int base, int width, int height, Class<? extends Inventory> adapterType, SlotLensProvider slots) {
        super(base, width, height, 1, 0, 0, adapterType, slots);
        this.init(slots);
    }

    protected void init(SlotLensProvider slots) {
        int y = 0;
        int base = this.base;
        while (y < this.height) {
            InventoryRowLens row = new InventoryRowLens(base, this.width, this.xBase, this.yBase + y, slots);
            this.addRow(row);
            ++y;
            base += this.width;
        }
        int x = 0;
        base = this.base;
        while (x < this.width) {
            InventoryColumnLens column = new InventoryColumnLens(base, this.height, this.stride, this.xBase + x, this.yBase, slots);
            this.addColumn(column);
            ++x;
            ++base;
        }
    }

    private void addRow(InventoryRowLens row) {
        super.addChild(row, new KeyValuePair[0]);
        this.rows.add(row);
    }

    private void addColumn(InventoryColumnLens column) {
        super.addChild(column, new KeyValuePair[0]);
        this.cols.add(column);
    }

    public InventoryRowLens getRow(int row) {
        return (InventoryRowLens)this.rows.get(row);
    }

    public InventoryColumnLens getColumn(int column) {
        return (InventoryColumnLens)this.cols.get(column);
    }

    @Override
    public Inventory getAdapter(Fabric fabric, Inventory parent) {
        return new GridInventoryAdapter(fabric, this, parent);
    }
}

