/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shaped;

import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class SpongeShapedRecipe
extends ShapedRecipe {
    private final Function<CraftingContainer, ItemStack> resultFunction;
    private final Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction;

    public SpongeShapedRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, Function<CraftingContainer, ItemStack> resultFunction, Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
        this.resultFunction = resultFunction;
        this.remainingItemsFunction = remainingItemsFunction;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        if (this.remainingItemsFunction != null) {
            return this.remainingItemsFunction.apply(inv);
        }
        return super.getRemainingItems((Container)inv);
    }

    public ItemStack assemble(CraftingContainer p_77572_1_) {
        if (this.resultFunction != null) {
            return this.resultFunction.apply(p_77572_1_);
        }
        return super.assemble(p_77572_1_);
    }

    public ItemStack getResultItem() {
        if (this.resultFunction != null) {
            return ItemStack.EMPTY;
        }
        return super.getResultItem();
    }
}

