/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.ingredient;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.crafting.Ingredient;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;

public class SpongeIngredientBuilder
implements Ingredient.Builder {
    private ItemType[] types;
    private ResourceKey itemTag;
    private ItemStack[] stacks;
    private Predicate<ItemStack> predicate;
    private ResourceKey key;

    @Override
    public Ingredient.Builder reset() {
        this.types = null;
        this.itemTag = null;
        this.stacks = null;
        this.predicate = null;
        this.key = null;
        return this;
    }

    @Override
    public Ingredient.Builder with(ItemType ... types) {
        this.reset();
        this.types = types;
        return this;
    }

    @Override
    public Ingredient.Builder with(Supplier<? extends ItemType> ... types) {
        this.reset();
        this.types = (ItemType[])Arrays.stream(types).map(Supplier::get).toArray(ItemType[]::new);
        return this;
    }

    @Override
    public Ingredient.Builder with(ResourceKey itemTag) {
        this.reset();
        this.itemTag = itemTag;
        return this;
    }

    @Override
    public Ingredient.Builder with(ItemStack ... types) {
        this.reset();
        this.stacks = types;
        return this;
    }

    @Override
    public Ingredient.Builder with(ItemStackSnapshot ... types) {
        this.reset();
        this.stacks = (ItemStack[])Arrays.stream(types).map(ItemStackSnapshot::createStack).toArray(ItemStack[]::new);
        return this;
    }

    @Override
    public Ingredient.Builder with(ResourceKey key, Predicate<ItemStack> predicate, ItemStack ... exemplaryTypes) {
        this.reset();
        this.stacks = exemplaryTypes;
        this.predicate = predicate;
        this.key = key;
        return this;
    }

    @Override
    public Ingredient build() {
        if (this.itemTag != null) {
            return IngredientUtil.of(this.itemTag);
        }
        if (this.types != null && this.types.length > 0) {
            return IngredientUtil.of(this.types);
        }
        if (this.stacks != null) {
            if (this.predicate != null) {
                return IngredientUtil.of(this.key, this.predicate, this.stacks);
            }
            return IngredientUtil.of(this.stacks);
        }
        throw new IllegalStateException("An ingredient must have at least one ItemType or an item tag");
    }
}

