/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.client;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.StaticTagHelper;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.client.LocalServer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.network.ClientSideConnection;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.api.world.client.ClientWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.client.MinecraftBridge;
import org.spongepowered.common.client.SpongeClient;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.registry.InitialRegistryData;
import org.spongepowered.common.registry.RegistryHolderLogic;
import org.spongepowered.common.registry.SpongeRegistryHolder;
import org.spongepowered.common.scheduler.ClientScheduler;
import org.spongepowered.common.util.LocaleCache;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin_API
implements SpongeClient,
SpongeRegistryHolder {
    @Shadow
    public ClientLevel level;
    @Shadow
    public LocalPlayer player;
    @Shadow
    @Nullable
    private Connection pendingConnection;
    @Shadow
    @Final
    public Options options;
    private final ClientScheduler api$scheduler = new ClientScheduler();
    private final RegistryHolderLogic api$registryHolder = new RegistryHolderLogic();

    @Shadow
    @Nullable
    public abstract IntegratedServer shadow$getSingleplayerServer();

    @Shadow
    public abstract PackRepository shadow$getResourcePackRepository();

    @Shadow
    public abstract ResourceManager shadow$getResourceManager();

    @Override
    public Optional<org.spongepowered.api.entity.living.player.client.LocalPlayer> player() {
        return Optional.ofNullable((org.spongepowered.api.entity.living.player.client.LocalPlayer)this.player);
    }

    @Override
    public Optional<LocalServer> server() {
        MinecraftBridge minecraftBridge = (MinecraftBridge)((Object)this);
        IntegratedServer integratedServer = minecraftBridge.bridge$getTemporaryIntegratedServer();
        if (integratedServer != null) {
            return Optional.ofNullable(integratedServer);
        }
        return Optional.ofNullable(this.shadow$getSingleplayerServer());
    }

    @Override
    public Optional<ClientWorld> world() {
        return Optional.ofNullable((ClientWorld)this.level);
    }

    @Override
    public Optional<ClientSideConnection> connection() {
        if (this.pendingConnection == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((ClientSideConnection)this.pendingConnection.getPacketListener());
    }

    @Override
    public Game game() {
        return Sponge.game();
    }

    @Override
    public CauseStackManager causeStackManager() {
        return PhaseTracker.getCauseStackManager();
    }

    @Override
    public org.spongepowered.api.resource.pack.PackRepository packRepository() {
        return (org.spongepowered.api.resource.pack.PackRepository)this.shadow$getResourcePackRepository();
    }

    @Override
    public org.spongepowered.api.resource.ResourceManager resourceManager() {
        return (org.spongepowered.api.resource.ResourceManager)this.shadow$getResourceManager();
    }

    @Override
    public ClientScheduler scheduler() {
        return this.api$scheduler;
    }

    @Override
    public boolean onMainThread() {
        return ((Minecraft)this).isSameThread();
    }

    @Override
    public Locale locale() {
        return LocaleCache.getLocale(this.options.languageCode);
    }

    @Override
    public <T> Registry<T> registry(RegistryType<T> type) {
        return this.api$registryHolder.registry(Objects.requireNonNull(type, "type"));
    }

    @Override
    public <T> Optional<Registry<T>> findRegistry(RegistryType<T> type) {
        return this.api$registryHolder.findRegistry(Objects.requireNonNull(type, "type"));
    }

    @Override
    public Stream<Registry<?>> streamRegistries(org.spongepowered.api.ResourceKey root) {
        return this.api$registryHolder.streamRegistries(Objects.requireNonNull(root, "root"));
    }

    @Override
    public void setRootMinecraftRegistry(net.minecraft.core.Registry<net.minecraft.core.Registry<?>> registry) {
        this.api$registryHolder.setRootMinecraftRegistry(registry);
    }

    @Override
    public <T> Registry<T> createRegistry(RegistryType<T> type, @org.checkerframework.checker.nullness.qual.Nullable InitialRegistryData<T> defaultValues, boolean isDynamic, @org.checkerframework.checker.nullness.qual.Nullable BiConsumer<ResourceKey<T>, T> callback) {
        return this.api$registryHolder.createRegistry(type, defaultValues, isDynamic, callback);
    }

    @Override
    public <T> void wrapTagHelperAsRegistry(RegistryType<Tag<T>> type, StaticTagHelper<T> helper) {
        this.api$registryHolder.wrapTagHelperAsRegistry(type, helper);
    }
}

