/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.chunk;

import net.minecraft.world.level.chunk.ChunkBiomeContainer;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ProtoChunk;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.generation.GenerationChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.level.chunk.ChunkBiomeContainerAccessor;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.world.volume.VolumeStreamUtils;

@Mixin(value={ProtoChunk.class})
public abstract class ProtoChunkMixin_API
implements GenerationChunk {
    @Shadow
    private ChunkBiomeContainer biomes;
    @Shadow
    private long inhabitedTime;
    @Shadow
    private volatile ChunkStatus status;

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        return VolumeStreamUtils.setBiomeOnNativeChunk(x, y, z, biome, () -> (ChunkBiomeContainerAccessor)this.biomes, () -> {});
    }

    @Override
    public Ticks inhabitedTime() {
        return new SpongeTicks(this.inhabitedTime);
    }

    @Override
    public void setInhabitedTime(Ticks newInhabitedTime) {
        this.inhabitedTime = newInhabitedTime.ticks();
    }

    @Override
    public boolean isEmpty() {
        return this.status == ChunkStatus.EMPTY;
    }
}

