/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.storage;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.PrimaryLevelData;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.generation.config.WorldGenerationConfig;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.level.LevelSettingsAccessor;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.server.BootstrapProperties;

@Mixin(value={PrimaryLevelData.class})
@Implements(value={@Interface(iface=ServerWorldProperties.class, prefix="serverWorldProperties$")})
public abstract class PrimaryLevelDataMixin_API
implements ServerWorldProperties {
    @Shadow
    private UUID wanderingTraderId;
    @Shadow
    private LevelSettings settings;

    @Shadow
    public abstract void shadow$setDifficulty(net.minecraft.world.Difficulty var1);

    @Shadow
    public abstract boolean shadow$isInitialized();

    @Shadow
    public abstract WorldGenSettings shadow$worldGenSettings();

    @Override
    public ResourceKey key() {
        return ((ResourceKeyBridge)((Object)this)).bridge$getKey();
    }

    @Override
    public Optional<ServerWorld> world() {
        return Optional.ofNullable((ServerWorld)((PrimaryLevelDataBridge)((Object)this)).bridge$world());
    }

    @Override
    public Optional<Component> displayName() {
        return ((PrimaryLevelDataBridge)((Object)this)).bridge$displayName();
    }

    @Override
    public void setDisplayName(Component displayName) {
        ((PrimaryLevelDataBridge)((Object)this)).bridge$setDisplayName(Objects.requireNonNull(displayName, "displayName"));
    }

    @Override
    public WorldType worldType() {
        return (WorldType)((PrimaryLevelDataBridge)((Object)this)).bridge$dimensionType();
    }

    @Override
    public void setWorldType(WorldType worldType) {
        ((PrimaryLevelDataBridge)((Object)this)).bridge$dimensionType((DimensionType)Objects.requireNonNull(worldType, "worldType"), true);
    }

    @Override
    public boolean initialized() {
        return this.shadow$isInitialized();
    }

    @Override
    public WorldGenerationConfig.Mutable worldGenerationConfig() {
        return (WorldGenerationConfig.Mutable)this.shadow$worldGenSettings();
    }

    @Override
    public void setHardcore(boolean hardcore) {
        ((LevelSettingsAccessor)this.settings).accessor$hardcode(hardcore);
    }

    @Override
    public boolean pvp() {
        return ((PrimaryLevelDataBridge)((Object)this)).bridge$pvp().orElse(BootstrapProperties.pvp);
    }

    @Override
    public void setPvp(boolean pvp) {
        ((PrimaryLevelDataBridge)((Object)this)).bridge$setPvp(pvp);
    }

    @Override
    public UUID uniqueId() {
        return ((PrimaryLevelDataBridge)((Object)this)).bridge$uniqueId();
    }

    @Override
    public boolean loadOnStartup() {
        return ((PrimaryLevelDataBridge)((Object)this)).bridge$loadOnStartup();
    }

    @Override
    public void setLoadOnStartup(boolean loadOnStartup) {
        ((PrimaryLevelDataBridge)((Object)this)).bridge$setLoadOnStartup(loadOnStartup);
    }

    @Override
    public boolean performsSpawnLogic() {
        return ((PrimaryLevelDataBridge)((Object)this)).bridge$performsSpawnLogic();
    }

    @Override
    public void setPerformsSpawnLogic(boolean keepLoaded) {
        ((PrimaryLevelDataBridge)((Object)this)).bridge$setPerformsSpawnLogic(keepLoaded);
    }

    @Override
    public void setCommands(boolean commands) {
        ((LevelSettingsAccessor)this.settings).accessor$allowCommands(commands);
    }

    @Override
    public int viewDistance() {
        return ((PrimaryLevelDataBridge)((Object)this)).bridge$viewDistance().orElse(BootstrapProperties.viewDistance);
    }

    @Override
    public void setViewDistance(@Nullable Integer viewDistance) {
        ((PrimaryLevelDataBridge)((Object)this)).bridge$setViewDistance(viewDistance);
    }

    @Override
    public void setDifficulty(Difficulty difficulty) {
        this.shadow$setDifficulty((net.minecraft.world.Difficulty)difficulty);
    }

    @Override
    public SerializationBehavior serializationBehavior() {
        return ((PrimaryLevelDataBridge)((Object)this)).bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
    }

    @Override
    public void setSerializationBehavior(SerializationBehavior behavior) {
        ((PrimaryLevelDataBridge)((Object)this)).bridge$setSerializationBehavior(behavior);
    }

    @Override
    public Optional<UUID> wanderTraderUniqueId() {
        return Optional.ofNullable(this.wanderingTraderId);
    }
}

