/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import co.aikar.timings.Timing;
import co.aikar.timings.sponge.ServerTimingsHandler;
import co.aikar.timings.sponge.TimingsManager;
import com.google.inject.Injector;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectProxy;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.commands.CommandSourceBridge;
import org.spongepowered.common.bridge.commands.CommandSourceProviderBridge;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.server.players.GameProfileCacheBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.datapack.SpongeDataPackManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.resourcepack.SpongeResourcePack;
import org.spongepowered.common.service.server.SpongeServerScopedServiceProvider;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
implements SpongeServer,
MinecraftServerBridge,
CommandSourceProviderBridge,
SubjectProxy,
CommandSourceBridge {
    @Shadow
    @Final
    private Map<ResourceKey<Level>, ServerLevel> levels;
    @Shadow
    @Final
    private GameProfileCache profileCache;
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    private int tickCount;
    @Shadow
    @Final
    protected LevelStorageSource.LevelStorageAccess storageSource;
    @Nullable
    private SpongeServerScopedServiceProvider impl$serviceProvider;
    @Nullable
    private ResourcePack impl$resourcePack;
    @Nullable
    private ServerTimingsHandler impl$timingsHandler;

    @Shadow
    public abstract CommandSourceStack shadow$createCommandSourceStack();

    @Shadow
    public abstract Iterable<ServerLevel> shadow$getAllLevels();

    @Shadow
    public abstract boolean shadow$isDedicatedServer();

    @Shadow
    public abstract boolean shadow$isRunning();

    @Shadow
    public abstract PlayerList shadow$getPlayerList();

    @Shadow
    public abstract PackRepository shadow$getPackRepository();

    @Shadow
    protected abstract void shadow$detectBundledResources();

    @Shadow
    protected abstract void loadLevel();

    @Override
    public Subject subject() {
        return SpongeCommon.game().systemSubject();
    }

    @Inject(method={"spin"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static void impl$setThreadOnServerPhaseTracker(Function<Thread, MinecraftServer> p_240784_0_, CallbackInfoReturnable<MinecraftServerMixin> cir, AtomicReference<MinecraftServer> atomicReference, Thread thread) {
        try {
            PhaseTracker.SERVER.setThread(thread);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not initialize the server PhaseTracker!");
        }
    }

    @Inject(method={"setResourcePack(Ljava/lang/String;Ljava/lang/String;)V"}, at={@At(value="HEAD")})
    private void impl$createSpongeResourcePackWrapper(String url, String hash, CallbackInfo ci) {
        if (url.length() == 0) {
            this.impl$resourcePack = null;
        } else {
            try {
                this.impl$resourcePack = SpongeResourcePack.create(url, hash, (Component)Component.empty());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ResourcePack bridge$getResourcePack() {
        return this.impl$resourcePack;
    }

    @Inject(method={"tickServer"}, at={@At(value="HEAD")})
    private void impl$onServerTickStart(CallbackInfo ci) {
        TimingsManager.FULL_SERVER_TICK.startTiming();
        this.scheduler().tick();
    }

    @Override
    public CommandSourceStack bridge$getCommandSource(Cause cause) {
        return this.shadow$createCommandSourceStack();
    }

    @Override
    public void bridge$addToCauseStack(CauseStackManager.StackFrame frame) {
        frame.pushCause(Sponge.systemSubject());
    }

    @Overwrite
    @DontObfuscate
    public String getServerModName() {
        return "sponge";
    }

    @Inject(method={"tickServer"}, at={@At(value="RETURN")})
    private void impl$completeTickCheckAnimation(CallbackInfo ci) {
        TimingsManager.FULL_SERVER_TICK.stopTiming();
    }

    @Inject(method={"stopServer"}, at={@At(value="TAIL")})
    private void impl$closeLevelSaveForOtherWorlds(CallbackInfo ci) {
        for (Map.Entry<ResourceKey<Level>, ServerLevel> entry : this.levels.entrySet()) {
            if (entry.getKey() == Level.OVERWORLD) continue;
            LevelStorageSource.LevelStorageAccess levelSave = ((ServerLevelBridge)entry.getValue()).bridge$getLevelSave();
            try {
                levelSave.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to unlock level {}", (Object)levelSave.getLevelId(), (Object)e);
            }
        }
    }

    @Inject(method={"sendMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$useTranslatingLogger(net.minecraft.network.chat.Component input, UUID sender, CallbackInfo ci) {
        LOGGER.info((Object)input);
        ci.cancel();
    }

    @ModifyConstant(method={"tickServer"}, constant={@Constant(intValue=6000, ordinal=0)})
    private int getSaveTickInterval(int tickInterval) {
        if (!this.shadow$isDedicatedServer()) {
            return tickInterval;
        }
        if (!this.shadow$isRunning()) {
            return this.tickCount + 1;
        }
        int autoPlayerSaveInterval = SpongeConfigs.getCommon().get().world.playerAutoSaveInterval;
        if (autoPlayerSaveInterval > 0 && this.tickCount % autoPlayerSaveInterval == 0) {
            this.shadow$getPlayerList().saveAll();
        }
        try (Timing timing = this.bridge$timingsHandler().save.startTiming();){
            this.saveAllChunks(true, false, false);
        }
        return this.tickCount + 1;
    }

    @Overwrite
    public boolean saveAllChunks(boolean suppressLog, boolean flush, boolean isForced) {
        for (ServerLevel world : this.shadow$getAllLevels()) {
            boolean log;
            SerializationBehavior serializationBehavior = ((PrimaryLevelDataBridge)world.getLevelData()).bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
            boolean bl = log = !suppressLog;
            if (!isForced) {
                boolean canSaveAtAll;
                InheritableConfigHandle<WorldConfig> adapter = ((PrimaryLevelDataBridge)world.getLevelData()).bridge$configAdapter();
                int autoSaveInterval = ((WorldConfig)adapter.get()).world.autoSaveInterval;
                if (log && this.bridge$performAutosaveChecks()) {
                    log = ((WorldConfig)adapter.get()).world.logAutoSave;
                }
                if (!this.shadow$isRunning() || this.tickCount % 6000 == 0) {
                    ((PrimaryLevelDataBridge)world.getLevelData()).bridge$configAdapter().save();
                }
                if (!(canSaveAtAll = serializationBehavior != SerializationBehavior.NONE) || this.bridge$performAutosaveChecks() && (autoSaveInterval <= 0 || serializationBehavior != SerializationBehavior.AUTOMATIC || this.tickCount % autoSaveInterval != 0)) continue;
                world.save(null, false, world.noSave);
                if (!log) continue;
                if (this.bridge$performAutosaveChecks()) {
                    LOGGER.info("Auto-saving data for world '{}'", (Object)((ServerWorld)world).key());
                    continue;
                }
                LOGGER.info("Saving data for world '{}'", (Object)((ServerWorld)world).key());
                continue;
            }
            if (log) {
                LOGGER.info("Manually saving data for world '{}'", (Object)((ServerWorld)world).key());
            }
            ((PrimaryLevelDataBridge)world.getLevelData()).bridge$configAdapter().save();
            world.save(null, false, world.noSave);
        }
        if (isForced || this.tickCount % 6000 == 0) {
            ((GameProfileCacheBridge)this.profileCache).bridge$setCanSave(true);
            this.profileCache.save();
            ((GameProfileCacheBridge)this.profileCache).bridge$setCanSave(false);
        }
        return true;
    }

    @Overwrite
    public void setDifficulty(Difficulty difficulty, boolean forceDifficulty) {
        for (ServerLevel world : this.shadow$getAllLevels()) {
            this.bridge$setDifficulty(world, difficulty, forceDifficulty);
        }
    }

    @Override
    public void bridge$setDifficulty(ServerLevel world, Difficulty newDifficulty, boolean forceDifficulty) {
        if (world.getLevelData().isDifficultyLocked() && !forceDifficulty) {
            return;
        }
        if (forceDifficulty) {
            if (!((PrimaryLevelDataBridge)world.getLevelData()).bridge$customDifficulty()) {
                ((PrimaryLevelDataBridge)world.getLevelData()).bridge$forceSetDifficulty(newDifficulty);
            }
        } else {
            ((PrimaryLevelData)world.getLevelData()).setDifficulty(newDifficulty);
        }
    }

    @Override
    public ServerTimingsHandler bridge$timingsHandler() {
        if (this.impl$timingsHandler == null) {
            this.impl$timingsHandler = new ServerTimingsHandler((MinecraftServer)this);
        }
        return this.impl$timingsHandler;
    }

    @Override
    public void bridge$initServices(Game game, Injector injector) {
        if (this.impl$serviceProvider == null) {
            this.impl$serviceProvider = new SpongeServerScopedServiceProvider(this, game, injector);
            this.impl$serviceProvider.init();
        }
    }

    @Override
    public SpongeServerScopedServiceProvider bridge$getServiceProvider() {
        return this.impl$serviceProvider;
    }

    @Inject(method={"reloadResources"}, at={@At(value="HEAD")})
    public void impl$reloadResources(Collection<String> datapacksToLoad, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        SpongeDataPackManager.INSTANCE.callRegisterDataPackValueEvents(this.storageSource.getLevelPath(LevelResource.DATAPACK_DIR), datapacksToLoad);
        this.shadow$getPackRepository().reload();
    }

    @Inject(method={"reloadResources"}, at={@At(value="RETURN")})
    public void impl$serializeDelayedDataPack(Collection<String> datapacksToLoad, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        ((CompletableFuture)cir.getReturnValue()).thenAccept(v -> SpongeDataPackManager.INSTANCE.serializeDelayedDataPack(DataPackTypes.WORLD));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

