/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.damagesource;

import com.google.common.base.MoreObjects;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.accessor.world.level.ExplosionAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.damagesource.DamageSourceBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.registry.provider.DamageSourceToTypeProvider;
import org.spongepowered.common.util.MemoizedSupplier;

@Mixin(value={DamageSource.class})
public abstract class DamageSourceMixin
implements DamageSourceBridge {
    @Shadow
    @Final
    @Mutable
    public static DamageSource LAVA;
    @Shadow
    @Final
    @Mutable
    public static DamageSource IN_FIRE;
    @Shadow
    @Final
    @Mutable
    public static DamageSource LIGHTNING_BOLT;
    @Shadow
    @Final
    @Mutable
    public static DamageSource HOT_FLOOR;
    @Shadow
    @Final
    @Mutable
    public static DamageSource ANVIL;
    @Shadow
    @Final
    @Mutable
    public static DamageSource FALLING_BLOCK;
    @Shadow
    @Final
    @Mutable
    public static DamageSource CACTUS;
    @Shadow
    @Final
    @Mutable
    public static DamageSource FALLING_STALACTITE;
    @Shadow
    @Final
    public String msgId;
    Supplier<DamageType> impl$damageType;

    @Shadow
    @Nullable
    public abstract Entity shadow$getEntity();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$setDamageTypeOnConstruction(String damageType, CallbackInfo ci) {
        this.bridge$resetDamageType();
    }

    @Inject(method={"getLocalizedDeathMessage"}, cancellable=true, at={@At(value="RETURN")})
    private void beforeGetDeathMessageReturn(LivingEntity livingEntity, CallbackInfoReturnable<Component> cir) {
        if (((Component)cir.getReturnValue()).getString().equals("death.attack." + this.msgId)) {
            cir.setReturnValue((Object)new TranslatableComponent("death.attack.generic", new Object[]{livingEntity.getDisplayName()}));
        }
    }

    @Inject(method={"explosion(Lnet/minecraft/world/level/Explosion;)Lnet/minecraft/world/damagesource/DamageSource;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onSetExplosionSource(@Nullable Explosion explosion, CallbackInfoReturnable<DamageSource> cir) {
        Entity entity;
        if (explosion != null && (entity = ((ExplosionAccessor)explosion).accessor$source()) != null && !((LevelBridge)((ExplosionAccessor)explosion).accessor$level()).bridge$isFake() && explosion.getSourceMob() == null && entity instanceof CreatorTrackedBridge) {
            CreatorTrackedBridge creatorBridge = (CreatorTrackedBridge)entity;
            creatorBridge.tracked$getCreatorUUID().flatMap(x -> Sponge.server().player((UUID)x)).ifPresent(player -> {
                IndirectEntityDamageSource damageSource = new IndirectEntityDamageSource("explosion.player", entity, (Entity)player);
                damageSource.setScalesWithDifficulty().setExplosion();
                cir.setReturnValue((Object)damageSource);
            });
        }
    }

    @Override
    public DamageType bridge$getDamageType() {
        return this.impl$damageType.get();
    }

    @Override
    public void bridge$resetDamageType() {
        this.impl$damageType = !this.msgId.contains(":") ? MemoizedSupplier.memoize(() -> DamageSourceToTypeProvider.INSTANCE.getOrCustom(this.msgId).get()) : MemoizedSupplier.memoize(() -> Sponge.game().registry(RegistryTypes.DAMAGE_TYPE).findValue(ResourceKey.resolve(this.msgId)).orElseGet(DamageTypes.CUSTOM));
    }

    @Override
    public void bridge$setLava() {
        LAVA = (DamageSource)this;
    }

    @Override
    public void bridge$setFireSource() {
        IN_FIRE = (DamageSource)this;
    }

    @Override
    public void bridge$setLightningSource() {
        LIGHTNING_BOLT = (DamageSource)this;
    }

    @Override
    public void bridge$setHotFloorSource() {
        HOT_FLOOR = (DamageSource)this;
    }

    @Override
    public void bridge$setFallingBlockSource() {
        FALLING_BLOCK = (DamageSource)this;
    }

    @Override
    public void bridge$setAnvilSource() {
        ANVIL = (DamageSource)this;
    }

    @Override
    public void bridge$setFallingStalactite() {
        FALLING_STALACTITE = (DamageSource)this;
    }

    @Override
    public void bridge$setCactusSource() {
        CACTUS = (DamageSource)this;
    }

    public String toString() {
        ResourceKey resourceKey = Sponge.game().registry(RegistryTypes.DAMAGE_TYPE).valueKey(this.impl$damageType.get());
        return MoreObjects.toStringHelper((String)"DamageSource").add("Name", (Object)this.msgId).add("Key", (Object)resourceKey).toString();
    }
}

