/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.player;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagContainer;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.api.event.cause.entity.damage.ModifierFunction;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.authlib.GameProfileHolderBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.entity.player.PlayerBridge;
import org.spongepowered.common.bridge.world.food.FoodDataBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.entity.LivingEntityMixin;
import org.spongepowered.common.util.DamageEventUtil;
import org.spongepowered.common.util.ExperienceHolderUtil;

@Mixin(value={net.minecraft.world.entity.player.Player.class})
public abstract class PlayerMixin
extends LivingEntityMixin
implements PlayerBridge,
GameProfileHolderBridge {
    @Shadow
    @Final
    protected static EntityDataAccessor<Byte> DATA_PLAYER_MODE_CUSTOMISATION;
    @Shadow
    public int experienceLevel;
    @Shadow
    public int totalExperience;
    @Shadow
    public float experienceProgress;
    @Shadow
    @Final
    private Abilities abilities;
    @Shadow
    @Final
    private Inventory inventory;
    @Shadow
    public AbstractContainerMenu containerMenu;
    @Shadow
    @Final
    public InventoryMenu inventoryMenu;
    @Shadow
    @Final
    private GameProfile gameProfile;
    private boolean impl$affectsSpawning = true;
    protected final boolean impl$isFake = ((PlatformEntityBridge)((net.minecraft.world.entity.player.Player)this)).bridge$isFakePlayer();

    @Shadow
    public abstract boolean shadow$isSpectator();

    @Shadow
    public abstract int shadow$getXpNeededForNextLevel();

    @Shadow
    @Nullable
    public abstract ItemEntity shadow$drop(ItemStack var1, boolean var2, boolean var3);

    @Shadow
    public abstract FoodData shadow$getFoodData();

    @Shadow
    public abstract GameProfile shadow$getGameProfile();

    @Shadow
    public abstract Scoreboard shadow$getScoreboard();

    @Shadow
    public abstract boolean shadow$isCreative();

    @Shadow
    public boolean shadow$canHarmPlayer(net.minecraft.world.entity.player.Player other) {
        return false;
    }

    @Shadow
    public abstract String shadow$getScoreboardName();

    @Shadow
    public abstract float shadow$getSpeed();

    @Shadow
    public abstract void shadow$resetAttackStrengthTicker();

    @Shadow
    public abstract float shadow$getAttackStrengthScale(float var1);

    @Shadow
    public abstract void shadow$sweepAttack();

    @Shadow
    public abstract void shadow$crit(net.minecraft.world.entity.Entity var1);

    @Shadow
    public abstract void shadow$magicCrit(net.minecraft.world.entity.Entity var1);

    @Shadow
    public abstract void shadow$awardStat(Stat<?> var1);

    @Shadow
    public abstract void shadow$awardStat(ResourceLocation var1, int var2);

    @Shadow
    public abstract void shadow$causeFoodExhaustion(float var1);

    @Shadow
    public abstract Component shadow$getDisplayName();

    @Shadow
    protected abstract void shadow$removeEntitiesOnShoulder();

    @Shadow
    public abstract void shadow$awardStat(ResourceLocation var1);

    @Shadow
    public abstract Abilities shadow$getAbilities();

    @Shadow
    public abstract Inventory shadow$getInventory();

    @Shadow
    public Either<Player.BedSleepingProblem, Unit> shadow$startSleepInBed(BlockPos param0) {
        return null;
    }

    @Override
    public boolean bridge$affectsSpawning() {
        return this.impl$affectsSpawning && !this.shadow$isSpectator() && !this.bridge$isVanishPreventsTargeting();
    }

    @Override
    public void bridge$setAffectsSpawning(boolean affectsSpawning) {
        this.impl$affectsSpawning = affectsSpawning;
    }

    @Override
    public GameProfile bridge$getGameProfile() {
        return this.gameProfile;
    }

    @Override
    public int bridge$getExperienceSinceLevel() {
        return this.totalExperience - ExperienceHolderUtil.xpAtLevel(this.experienceLevel);
    }

    @Override
    public void bridge$setExperienceSinceLevel(int experience) {
        this.totalExperience = ExperienceHolderUtil.xpAtLevel(this.experienceLevel) + experience;
        this.experienceProgress = (float)experience / (float)this.shadow$getXpNeededForNextLevel();
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isSleeping()Z"))
    private boolean impl$postSleepingEvent(net.minecraft.world.entity.player.Player self) {
        if (self.isSleeping()) {
            if (!((LevelBridge)this.level).bridge$isFake()) {
                CauseStackManager csm = PhaseTracker.getCauseStackManager();
                csm.pushCause(this);
                BlockPos bedLocation = this.shadow$getSleepingPos().get();
                BlockSnapshot snapshot = ((ServerWorld)this.level).createSnapshot(bedLocation.getX(), bedLocation.getY(), bedLocation.getZ());
                SpongeCommon.post(SpongeEventFactory.createSleepingEventTick(csm.currentCause(), snapshot, (Living)((Object)this)));
                csm.popCause();
            }
            return true;
        }
        return false;
    }

    @Redirect(method={"getDisplayName"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getName()Lnet/minecraft/network/chat/Component;"))
    private Component impl$useCustomNameIfSet(net.minecraft.world.entity.player.Player playerEntity) {
        if (playerEntity instanceof net.minecraft.server.level.ServerPlayer) {
            if (playerEntity.hasCustomName()) {
                return playerEntity.getCustomName();
            }
            return playerEntity.getName();
        }
        return playerEntity.getName();
    }

    @Redirect(method={"playSound(Lnet/minecraft/sounds/SoundEvent;FF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V"))
    private void impl$playNoSoundToOthersIfVanished(Level world, net.minecraft.world.entity.player.Player player, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch) {
        if (!this.bridge$isVanished()) {
            this.level.playSound(player, x, y, z, sound, category, volume, pitch);
        }
    }

    @Redirect(method={"canUseGameMasterBlocks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getPermissionLevel()I"))
    private int impl$checkPermissionForCommandBlock(net.minecraft.world.entity.player.Player playerEntity) {
        if (this instanceof Subject) {
            return ((Subject)((Object)this)).hasPermission("minecraft.commandblock") ? 2 : 0;
        }
        return this.shadow$getPermissionLevel();
    }

    @Redirect(method={"mayUseItemAt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hasAdventureModePlaceTagForBlock(Lnet/minecraft/tags/TagContainer;Lnet/minecraft/world/level/block/state/pattern/BlockInWorld;)Z"))
    private boolean impl$callChangeBlockPre(ItemStack stack, TagContainer tagSupplier, BlockInWorld cachedBlockInfo) {
        if (!stack.hasAdventureModePlaceTagForBlock(tagSupplier, cachedBlockInfo)) {
            return false;
        }
        if (this.level instanceof LevelBridge && !((LevelBridge)this.level).bridge$isFake() && ShouldFire.CHANGE_BLOCK_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(stack));
                boolean bl = !SpongeCommonEventFactory.callChangeBlockEventPre((ServerLevelBridge)this.level, cachedBlockInfo.getPos(), (Object)this).isCancelled();
                return bl;
            }
        }
        return true;
    }

    @Overwrite
    @Nullable
    public ItemEntity drop(ItemStack itemStackIn, boolean unused) {
        return this.shadow$drop(itemStackIn, false, false);
    }

    @Inject(method={"getFireImmuneTicks"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$useCustomFireImmuneTicks(CallbackInfoReturnable<Integer> ci) {
        if (this.impl$hasCustomFireImmuneTicks) {
            ci.setReturnValue((Object)this.impl$fireImmuneTicks);
        }
    }

    @Inject(method={"interactOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void impl$onRightClickEntity(net.minecraft.world.entity.Entity entityToInteractOn, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (!((net.minecraft.world.entity.player.Player)this instanceof net.minecraft.server.level.ServerPlayer)) {
            return;
        }
        InteractEntityEvent.Secondary event = SpongeCommonEventFactory.callInteractEntityEventSecondary((net.minecraft.server.level.ServerPlayer)this, this.shadow$getItemInHand(hand), entityToInteractOn, hand, null);
        if (event.isCancelled()) {
            cir.setReturnValue((Object)InteractionResult.FAIL);
        }
    }

    @Overwrite
    public void attack(net.minecraft.world.entity.Entity targetEntity) {
        if (!PlatformHooks.INSTANCE.getEntityHooks().checkAttackEntity((net.minecraft.world.entity.player.Player)this, targetEntity)) {
            return;
        }
        if (targetEntity.isAttackable() && !targetEntity.skipAttackInteraction((net.minecraft.world.entity.Entity)((net.minecraft.world.entity.player.Player)this))) {
            double originalBaseDamage = this.shadow$getAttribute(Attributes.ATTACK_DAMAGE).getValue();
            float damage = (float)originalBaseDamage;
            float enchantmentDamage = 0.0f;
            float attackStrength = this.shadow$getAttackStrengthScale(0.5f);
            ArrayList<DamageFunction> originalFunctions = new ArrayList<DamageFunction>();
            MobType creatureAttribute = targetEntity instanceof LivingEntity ? ((LivingEntity)targetEntity).getMobType() : MobType.UNDEFINED;
            List<DamageFunction> enchantmentModifierFunctions = DamageEventUtil.createAttackEnchantmentFunction(this.shadow$getMainHandItem(), creatureAttribute, attackStrength);
            List enchantmentModifiers = enchantmentModifierFunctions.stream().map(ModifierFunction::modifier).collect(Collectors.toList());
            enchantmentDamage = (float)enchantmentModifierFunctions.stream().map(ModifierFunction::function).mapToDouble(function -> function.applyAsDouble(originalBaseDamage)).sum();
            originalFunctions.addAll(enchantmentModifierFunctions);
            originalFunctions.add(DamageEventUtil.provideCooldownAttackStrengthFunction((net.minecraft.world.entity.player.Player)this, attackStrength));
            enchantmentDamage *= attackStrength;
            this.shadow$resetAttackStrengthTicker();
            if ((damage *= 0.2f + attackStrength * attackStrength * 0.8f) > 0.0f || enchantmentDamage > 0.0f) {
                boolean isMainthread;
                ItemStack itemstack;
                boolean isStrongAttack = attackStrength > 0.9f;
                boolean isSprintingAttack = false;
                boolean isCriticalAttack = false;
                boolean isSweapingAttack = false;
                int knockbackModifier = 0;
                knockbackModifier += EnchantmentHelper.getKnockbackBonus((LivingEntity)((net.minecraft.world.entity.player.Player)this));
                if (this.shadow$isSprinting() && isStrongAttack) {
                    ++knockbackModifier;
                    isSprintingAttack = true;
                }
                isCriticalAttack = isStrongAttack && this.fallDistance > 0.0f && !this.onGround && !this.shadow$onClimbable() && !this.shadow$isInWater() && !this.shadow$hasEffect(MobEffects.BLINDNESS) && !this.shadow$isPassenger() && targetEntity instanceof LivingEntity;
                boolean bl = isCriticalAttack = isCriticalAttack && !this.shadow$isSprinting();
                if (isCriticalAttack) {
                    originalFunctions.add(DamageEventUtil.provideCriticalAttackTuple((net.minecraft.world.entity.player.Player)this));
                }
                double distanceWalkedDelta = this.walkDist - this.walkDistO;
                ItemStack heldItem = this.shadow$getMainHandItem();
                if (isStrongAttack && !isCriticalAttack && !isSprintingAttack && this.onGround && distanceWalkedDelta < (double)this.shadow$getSpeed() && (itemstack = heldItem).getItem() instanceof SwordItem) {
                    isSweapingAttack = true;
                }
                DamageSource damageSource = DamageSource.playerAttack((net.minecraft.world.entity.player.Player)((net.minecraft.world.entity.player.Player)this));
                boolean bl2 = isMainthread = !this.level.isClientSide;
                if (isMainthread) {
                    PhaseTracker.getInstance().pushCause(damageSource);
                }
                Cause currentCause = isMainthread ? PhaseTracker.getInstance().currentCause() : Cause.of(EventContext.empty(), damageSource);
                AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(currentCause, (Entity)targetEntity, originalFunctions, knockbackModifier, originalBaseDamage);
                SpongeCommon.post(event);
                if (isMainthread) {
                    PhaseTracker.getInstance().popCause();
                }
                if (event.isCancelled()) {
                    return;
                }
                damage = (float)event.finalOutputDamage();
                double attackDamage = damage;
                knockbackModifier = (int)event.knockbackModifier();
                enchantmentDamage = (float)enchantmentModifiers.stream().mapToDouble(event::outputDamage).sum();
                float targetOriginalHealth = 0.0f;
                boolean litEntityOnFire = false;
                int fireAspectModifier = EnchantmentHelper.getFireAspect((LivingEntity)((net.minecraft.world.entity.player.Player)this));
                if (targetEntity instanceof LivingEntity) {
                    targetOriginalHealth = ((LivingEntity)targetEntity).getHealth();
                    if (fireAspectModifier > 0 && !targetEntity.isOnFire()) {
                        litEntityOnFire = true;
                        targetEntity.setSecondsOnFire(1);
                    }
                }
                Vec3 targetMotion = targetEntity.getDeltaMovement();
                boolean attackSucceeded = targetEntity.hurt(DamageSource.playerAttack((net.minecraft.world.entity.player.Player)((net.minecraft.world.entity.player.Player)this)), damage);
                if (attackSucceeded) {
                    if (knockbackModifier > 0) {
                        if (targetEntity instanceof LivingEntity) {
                            ((LivingEntity)targetEntity).knockback((double)((float)knockbackModifier * 0.5f), (double)Mth.sin((float)(this.shadow$getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.shadow$getYRot() * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.push((double)(-Mth.sin((float)(this.shadow$getYRot() * ((float)Math.PI / 180))) * (float)knockbackModifier * 0.5f), 0.1, (double)(Mth.cos((float)(this.shadow$getYRot() * ((float)Math.PI / 180))) * (float)knockbackModifier * 0.5f));
                        }
                        this.shadow$setDeltaMovement(this.shadow$getDeltaMovement().multiply(0.6, 1.0, 0.6));
                        this.shadow$setSprinting(false);
                    }
                    if (isSweapingAttack) {
                        for (LivingEntity livingEntity : this.level.getEntitiesOfClass(LivingEntity.class, targetEntity.getBoundingBox().inflate(1.0, 0.25, 1.0))) {
                            if (livingEntity == (net.minecraft.world.entity.player.Player)this || livingEntity == targetEntity || this.shadow$isAlliedTo((net.minecraft.world.entity.Entity)livingEntity) || livingEntity instanceof ArmorStand && ((ArmorStand)livingEntity).isMarker() || !(this.shadow$distanceToSqr((net.minecraft.world.entity.Entity)livingEntity) < 9.0)) continue;
                            EntityDamageSource sweepingAttackSource = (EntityDamageSource)((EntityDamageSource.Builder)((EntityDamageSource.Builder)EntityDamageSource.builder().entity((Player)((Object)this))).type(DamageTypes.SWEEPING_ATTACK)).build();
                            CauseStackManager.StackFrame frame = isMainthread ? PhaseTracker.getInstance().pushCauseFrame() : null;
                            try {
                                if (isMainthread) {
                                    frame.pushCause(sweepingAttackSource);
                                }
                                ItemStackSnapshot heldSnapshot = ItemStackUtil.snapshotOf(heldItem);
                                if (isMainthread) {
                                    frame.addContext(EventContextKeys.WEAPON, heldSnapshot);
                                }
                                DamageFunction sweapingFunction = DamageFunction.of(DamageModifier.builder().cause(Cause.of(EventContext.empty(), heldSnapshot)).item(heldSnapshot).type(DamageModifierTypes.SWEEPING).build(), incoming -> (double)EnchantmentHelper.getSweepingDamageRatio((LivingEntity)((net.minecraft.world.entity.player.Player)this)) * attackDamage);
                                ArrayList<DamageFunction> sweapingFunctions = new ArrayList<DamageFunction>();
                                sweapingFunctions.add(sweapingFunction);
                                AttackEntityEvent sweepingAttackEvent = SpongeEventFactory.createAttackEntityEvent(currentCause, (Entity)livingEntity, sweapingFunctions, 1.0f, 1.0);
                                SpongeCommon.post(sweepingAttackEvent);
                                if (sweepingAttackEvent.isCancelled()) continue;
                                livingEntity.knockback((double)(sweepingAttackEvent.knockbackModifier() * 0.4f), (double)Mth.sin((float)(this.shadow$getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.shadow$getYRot() * ((float)Math.PI / 180)))));
                                livingEntity.hurt(DamageSource.playerAttack((net.minecraft.world.entity.player.Player)((net.minecraft.world.entity.player.Player)this)), (float)sweepingAttackEvent.finalOutputDamage());
                            }
                            finally {
                                if (frame == null) continue;
                                frame.close();
                            }
                        }
                        this.level.playSound(null, this.shadow$getX(), this.shadow$getY(), this.shadow$getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, this.shadow$getSoundSource(), 1.0f, 1.0f);
                        this.shadow$sweepAttack();
                    }
                    if (targetEntity instanceof net.minecraft.server.level.ServerPlayer && targetEntity.hurtMarked) {
                        ((net.minecraft.server.level.ServerPlayer)targetEntity).connection.send((Packet)new ClientboundSetEntityMotionPacket(targetEntity));
                        targetEntity.hurtMarked = false;
                        targetEntity.setDeltaMovement(targetMotion);
                    }
                    if (isCriticalAttack) {
                        this.level.playSound(null, this.shadow$getX(), this.shadow$getY(), this.shadow$getZ(), SoundEvents.PLAYER_ATTACK_CRIT, this.shadow$getSoundSource(), 1.0f, 1.0f);
                        this.shadow$crit(targetEntity);
                    }
                    if (!isCriticalAttack && !isSweapingAttack) {
                        if (isStrongAttack) {
                            this.level.playSound(null, this.shadow$getX(), this.shadow$getY(), this.shadow$getZ(), SoundEvents.PLAYER_ATTACK_STRONG, this.shadow$getSoundSource(), 1.0f, 1.0f);
                        } else {
                            this.level.playSound(null, this.shadow$getX(), this.shadow$getY(), this.shadow$getZ(), SoundEvents.PLAYER_ATTACK_WEAK, this.shadow$getSoundSource(), 1.0f, 1.0f);
                        }
                    }
                    if (enchantmentDamage > 0.0f) {
                        this.shadow$magicCrit(targetEntity);
                    }
                    this.shadow$setLastHurtMob(targetEntity);
                    if (targetEntity instanceof LivingEntity) {
                        EnchantmentHelper.doPostHurtEffects((LivingEntity)((LivingEntity)targetEntity), (net.minecraft.world.entity.Entity)((net.minecraft.world.entity.player.Player)this));
                    }
                    EnchantmentHelper.doPostDamageEffects((LivingEntity)((net.minecraft.world.entity.player.Player)this), (net.minecraft.world.entity.Entity)targetEntity);
                    ItemStack itemstack1 = this.shadow$getMainHandItem();
                    net.minecraft.world.entity.Entity entity = targetEntity;
                    if (targetEntity instanceof EnderDragonPart) {
                        entity = ((EnderDragonPart)targetEntity).parentMob;
                    }
                    if (!this.level.isClientSide && !itemstack1.isEmpty() && entity instanceof LivingEntity) {
                        itemstack1.hurtEnemy((LivingEntity)entity, (net.minecraft.world.entity.player.Player)this);
                        if (itemstack1.isEmpty()) {
                            this.shadow$setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                        }
                        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
                        TransactionalCaptureSupplier transactor = context.getTransactor();
                        transactor.logPlayerInventoryChange((net.minecraft.world.entity.player.Player)this, PlayerInventoryTransaction.EventCreator.STANDARD);
                        this.inventoryMenu.broadcastChanges();
                    }
                    if (targetEntity instanceof LivingEntity) {
                        float f5 = targetOriginalHealth - ((LivingEntity)targetEntity).getHealth();
                        this.shadow$awardStat(Stats.DAMAGE_DEALT, Math.round(f5 * 10.0f));
                        if (fireAspectModifier > 0) {
                            targetEntity.setSecondsOnFire(fireAspectModifier * 4);
                        }
                        if (this.level instanceof ServerWorld && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, targetEntity.getX(), targetEntity.getY() + (double)(targetEntity.getBbHeight() * 0.5f), targetEntity.getZ(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.shadow$causeFoodExhaustion(0.1f);
                } else {
                    this.level.playSound(null, this.shadow$getX(), this.shadow$getY(), this.shadow$getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, this.shadow$getSoundSource(), 1.0f, 1.0f);
                    if (litEntityOnFire) {
                        targetEntity.clearFire();
                    }
                }
            }
        }
    }

    @Override
    public boolean impl$canCallIgniteEntityEvent() {
        return super.impl$canCallIgniteEntityEvent() && !this.shadow$isSpectator() && !this.shadow$isCreative();
    }

    @Inject(method={"canHarmPlayer"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onCanHarmPlayer(net.minecraft.world.entity.player.Player other, CallbackInfoReturnable<Boolean> cir) {
        if (!(other instanceof ServerPlayer)) {
            return;
        }
        Team otherTeam = other.getTeam();
        PlayerTeam thisTeam = ((Scoreboard)((ServerPlayerBridge)other).bridge$getScoreboard()).getPlayersTeam(this.shadow$getScoreboardName());
        cir.setReturnValue((Object)(otherTeam == null || !otherTeam.isAlliedTo((Team)thisTeam) || otherTeam.isAllowFriendlyFire() ? 1 : 0));
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$foodData(CallbackInfo ci) {
        ((FoodDataBridge)this.shadow$getFoodData()).bridge$setPlayer((net.minecraft.world.entity.player.Player)this);
    }
}

