/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.projectile.FishingBobber;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;

@Mixin(value={FishingHook.class})
public abstract class FishingHookMixin
extends EntityMixin {
    @Shadow
    @Nullable
    private net.minecraft.world.entity.Entity hookedIn;
    @Shadow
    private int nibble;
    @Shadow
    @Final
    private int luck;
    @Nullable
    private ProjectileSource impl$projectileSource;

    @Shadow
    @Nullable
    public abstract Player shadow$getPlayerOwner();

    @Shadow
    protected abstract void shadow$pullEntity(net.minecraft.world.entity.Entity var1);

    @Inject(method={"setHookedEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetHookedEntity(@Nullable net.minecraft.world.entity.Entity hookedIn, CallbackInfo ci) {
        if (hookedIn != null && SpongeCommon.post(SpongeEventFactory.createFishingEventHookEntity(PhaseTracker.getCauseStackManager().currentCause(), (Entity)hookedIn, (FishingBobber)((Object)this)))) {
            this.hookedIn = null;
            ci.cancel();
        }
    }

    @Overwrite
    public int retrieve(ItemStack stack) {
        Player playerEntity = this.shadow$getPlayerOwner();
        if (!this.level.isClientSide && playerEntity != null) {
            List<Transaction<ItemStackSnapshot>> transactions;
            int i = 0;
            if (this.nibble > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.level).withParameter(LootContextParams.ORIGIN, (Object)this.shadow$position()).withParameter(LootContextParams.TOOL, (Object)stack).withParameter(LootContextParams.THIS_ENTITY, (Object)((net.minecraft.world.entity.Entity)this)).withRandom(this.random).withLuck((float)this.luck + playerEntity.getLuck());
                LootTable lootTable = this.level.getServer().getLootTables().get(BuiltInLootTables.FISHING);
                List list = lootTable.getRandomItems(lootcontext$builder.create(LootContextParamSets.FISHING));
                transactions = list.stream().map(ItemStackUtil::snapshotOf).map(snapshot -> new Transaction<ItemStackSnapshot>((ItemStackSnapshot)snapshot, (ItemStackSnapshot)snapshot)).collect(Collectors.toList());
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)playerEntity, stack, (FishingHook)this, (Collection)list);
            } else {
                transactions = new ArrayList<Transaction<ItemStackSnapshot>>();
            }
            PhaseTracker.getCauseStackManager().pushCause(playerEntity);
            if (SpongeCommon.post(SpongeEventFactory.createFishingEventStop(PhaseTracker.getCauseStackManager().currentCause(), (FishingBobber)((Object)this), transactions))) {
                return 0;
            }
            if (this.hookedIn != null) {
                this.shadow$pullEntity(this.hookedIn);
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)playerEntity, stack, (FishingHook)this, Collections.emptyList());
                this.level.broadcastEntityEvent((net.minecraft.world.entity.Entity)this, (byte)31);
                int n = i = this.hookedIn instanceof ItemEntity ? 3 : 5;
            }
            if (!transactions.isEmpty()) {
                for (Transaction transaction : transactions) {
                    if (!transaction.isValid()) continue;
                    ItemStack itemstack = (ItemStack)((ItemStackSnapshot)transaction.finalReplacement()).createStack();
                    ItemEntity entityitem = new ItemEntity(this.level, this.shadow$getX(), this.shadow$getY(), this.shadow$getZ(), itemstack);
                    double d0 = playerEntity.getX() - this.shadow$getX();
                    double d1 = playerEntity.getY() - this.shadow$getY();
                    double d2 = playerEntity.getZ() - this.shadow$getZ();
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    entityitem.setDeltaMovement(d0 * 0.1, d1 * 0.1 + Math.sqrt(d3) * 0.08, d2 * 0.1);
                    this.level.addFreshEntity((net.minecraft.world.entity.Entity)entityitem);
                    playerEntity.level.addFreshEntity((net.minecraft.world.entity.Entity)new ExperienceOrb(playerEntity.level, playerEntity.getX(), playerEntity.getY() + 0.5, playerEntity.getZ() + 0.5, this.random.nextInt(6) + 1));
                    if (!itemstack.is((Tag)ItemTags.FISHES)) continue;
                    playerEntity.awardStat(Stats.FISH_CAUGHT, 1);
                }
                PhaseTracker.getCauseStackManager().popCause();
                i = Math.max(i, 1);
            }
            if (this.onGround) {
                i = 2;
            }
            this.shadow$discard();
            return i;
        }
        return 0;
    }

    @Inject(method={"checkCollision"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;onHit(Lnet/minecraft/world/phys/HitResult;)V")})
    private void impl$callCollideImpactEvent(CallbackInfo ci, HitResult hitResult) {
        if (hitResult.getType() == HitResult.Type.MISS || ((LevelBridge)this.level).bridge$isFake()) {
            return;
        }
        if (SpongeCommonEventFactory.handleCollideImpactEvent((net.minecraft.world.entity.Entity)((FishingHook)this), ((Projectile)((Object)this)).get(Keys.SHOOTER).orElse(null), hitResult)) {
            this.shadow$discard();
            ci.cancel();
        }
    }
}

