/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.scores;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.bridge.world.scores.ScoreboardBridge;
import org.spongepowered.common.scoreboard.SpongeObjective;

@Mixin(value={Objective.class})
public abstract class ObjectiveMixin
implements ObjectiveBridge {
    @Shadow
    @Final
    private Scoreboard scoreboard;
    @Nullable
    private SpongeObjective impl$spongeScoreboard;

    @Override
    public SpongeObjective bridge$getSpongeObjective() {
        return this.impl$spongeScoreboard;
    }

    @Override
    public void bridge$setSpongeObjective(SpongeObjective spongeObjective) {
        this.impl$spongeScoreboard = spongeObjective;
    }

    @Inject(method={"setDisplayName"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetDisplayName(Component name, CallbackInfo ci) {
        if (this.scoreboard != null && ((ScoreboardBridge)this.scoreboard).bridge$isClient()) {
            return;
        }
        if (this.impl$spongeScoreboard == null) {
            SpongeCommon.logger().warn("Returning objective cause null!");
            ci.cancel();
            return;
        }
        this.impl$spongeScoreboard.storeDisplayName(SpongeAdventure.asAdventure(name));
    }

    @Inject(method={"setRenderType"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetRenderType(ObjectiveCriteria.RenderType type, CallbackInfo ci) {
        if (this.scoreboard != null && ((ScoreboardBridge)this.scoreboard).bridge$isClient()) {
            return;
        }
        if (this.impl$spongeScoreboard == null) {
            SpongeCommon.logger().warn("Returning render objective cause null!");
            ci.cancel();
            return;
        }
        this.impl$spongeScoreboard.storeDisplayMode((ObjectiveDisplayMode)type);
    }
}

