/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollision.world.level;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.entitycollision.CollisionCapabilityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={Level.class})
public abstract class LevelMixin_EntityCollision
implements AutoCloseable,
LevelAccessor,
LevelBridge {
    @Shadow
    public abstract boolean shadow$isClientSide();

    @Inject(method={"*(Lnet/minecraft/world/entity/Entity;Ljava/util/function/Predicate;Ljava/util/List;Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", remap=false)}, cancellable=true)
    private void collisionsImpl$checkForCollisionRulesA(Entity entity, Predicate<? super Entity> filter, List<Entity> entities, Entity candidate, CallbackInfo ci) {
        this.collisionsImpl$commonCollisionCheck(entity, entities, ci);
    }

    @Inject(method={"*(Ljava/util/function/Predicate;Ljava/util/List;Lnet/minecraft/world/level/entity/EntityTypeTest;Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", remap=false)}, cancellable=true)
    private void collisionsImpl$checkForCollisionRulesA(Predicate<? super Entity> filter, List<Entity> entities, EntityTypeTest<?, ?> entity, Entity candidate, CallbackInfo ci) {
        this.collisionsImpl$commonCollisionCheck(entity, entities, ci);
    }

    private void collisionsImpl$commonCollisionCheck(@Coerce @Nullable Object entity, List<Entity> entities, CallbackInfo ci) {
        EntityTypeTest test;
        if (this.shadow$isClientSide() || entities == null) {
            return;
        }
        Object object = entity;
        if (object instanceof EntityTypeTest && (Player.class.isAssignableFrom((test = (EntityTypeTest)object).getBaseClass()) || ItemEntity.class == test.getBaseClass())) {
            return;
        }
        if (entity instanceof Player || entity instanceof EnderDragon) {
            return;
        }
        if (entity instanceof LivingEntity && ((CollisionCapabilityBridge)entity).collision$isRunningCollideWithNearby()) {
            return;
        }
        if (!this.entityCollision$allowEntityCollision(entities)) {
            ci.cancel();
        }
    }

    private <T extends Entity> boolean entityCollision$allowEntityCollision(List<T> entities) {
        if (this.bridge$isFake()) {
            return true;
        }
        PhaseContext<@NonNull ?> phaseContext = PhaseTracker.getInstance().getPhaseContext();
        if (!phaseContext.allowsEntityCollisionEvents()) {
            return true;
        }
        Object source = phaseContext.getSource();
        if (source == null) {
            return true;
        }
        CollisionCapabilityBridge collisionBridge = null;
        if (source instanceof LocatableBlock) {
            LocatableBlock locatable = (LocatableBlock)source;
            BlockType blockType = locatable.location().block().type();
            collisionBridge = (CollisionCapabilityBridge)((Object)blockType);
        } else if (source instanceof CollisionCapabilityBridge) {
            collisionBridge = (CollisionCapabilityBridge)source;
        }
        if (collisionBridge == null) {
            return true;
        }
        if (collisionBridge.collision$requiresCollisionsCacheRefresh()) {
            collisionBridge.collision$initializeCollisionState((Level)this);
            collisionBridge.collision$requiresCollisionsCacheRefresh(false);
        }
        return collisionBridge.collision$getMaxCollisions() < 0 || entities.size() < collisionBridge.collision$getMaxCollisions();
    }
}

