/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.api.inventory.container;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ContainerType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.server.level.ServerPlayer_ContainerListenerAccessor;
import org.spongepowered.common.bridge.world.inventory.container.ContainerBridge;
import org.spongepowered.common.inventory.adapter.impl.DefaultImplementedAdapterInventory;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={AbstractContainerMenu.class}, priority=998)
public abstract class ContainerMixin_Inventory_API
implements Container,
DefaultImplementedAdapterInventory.WithClear {
    @Shadow
    @Final
    private List<ContainerListener> containerListeners;
    @Shadow
    @Final
    @Nullable
    private MenuType<?> menuType;

    @Override
    public boolean isViewedSlot(Slot slot) {
        Set<net.minecraft.world.inventory.Slot> set;
        if (slot instanceof net.minecraft.world.inventory.Slot && (set = ((ContainerBridge)((Object)this)).bridge$getInventories().get(((net.minecraft.world.inventory.Slot)slot).container)) != null && set.contains(slot)) {
            if (((ContainerBridge)((Object)this)).bridge$getInventories().size() == 1) {
                return true;
            }
            if (((net.minecraft.world.inventory.Slot)slot).container.getClass() != net.minecraft.world.entity.player.Inventory.class) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Inventory> viewed() {
        ArrayList<Inventory> list = new ArrayList<Inventory>();
        for (net.minecraft.world.Container inv : ((ContainerBridge)((Object)this)).bridge$getInventories().keySet()) {
            Inventory inventory = InventoryUtil.toInventory(inv, null);
            list.add(inventory);
        }
        return list;
    }

    @Override
    public boolean setCursor(org.spongepowered.api.item.inventory.ItemStack item) {
        if (!this.isOpen()) {
            return false;
        }
        ItemStack nativeStack = ItemStackUtil.toNative(item);
        this.listeners().stream().findFirst().ifPresent(p -> p.containerMenu.setCarried(nativeStack));
        return true;
    }

    @Override
    public Optional<org.spongepowered.api.item.inventory.ItemStack> cursor() {
        return this.listeners().stream().findFirst().map(p -> p.containerMenu.getCarried()).map(ItemStackUtil::fromNative);
    }

    @Override
    public ServerPlayer viewer() {
        return this.listeners().stream().filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("Container without viewer"));
    }

    @Override
    public boolean isOpen() {
        ContainerMixin_Inventory_API thisContainer = this;
        return this.viewer().openInventory().map(c -> c == thisContainer).orElse(false);
    }

    @Override
    public ContainerType type() {
        return (ContainerType)this.menuType;
    }

    private List<net.minecraft.server.level.ServerPlayer> listeners() {
        return this.containerListeners.stream().filter(listener -> this.containerListeners.get(0).getClass().getEnclosingClass() == net.minecraft.server.level.ServerPlayer.class).map(listener -> ((ServerPlayer_ContainerListenerAccessor)listener).accessor$this$0()).collect(Collectors.toList());
    }
}

