/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.api.server.level;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.bridge.world.inventory.container.ContainerBridge;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.mixin.inventory.api.world.entity.player.PlayerMixin_Inventory_API;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin_Inventory_API
extends PlayerMixin_Inventory_API
implements org.spongepowered.api.entity.living.player.server.ServerPlayer {
    @Override
    public Optional<Container> openInventory() {
        return Optional.ofNullable((Container)this.containerMenu);
    }

    @Override
    public Optional<Container> openInventory(Inventory inventory) throws IllegalArgumentException {
        return this.openInventory(inventory, null);
    }

    @Override
    public Optional<Container> openInventory(Inventory inventory, Component displayName) {
        ContainerBridge openContainer = (ContainerBridge)this.containerMenu;
        if (openContainer.bridge$isInUse()) {
            throw new UnsupportedOperationException("This player is currently modifying an open container. Opening a new one must be delayed!");
        }
        return Optional.ofNullable((Container)InventoryEventFactory.displayContainer((ServerPlayer)this, inventory, displayName));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public boolean closeInventory() throws IllegalArgumentException {
        AbstractContainerMenu openContainer = this.containerMenu;
        if (((ContainerBridge)openContainer).bridge$isInUse()) {
            throw new UnsupportedOperationException("This player is currently modifying an open container. Closing it must be delayed!");
        }
        ServerPlayer player = (ServerPlayer)this;
        try (@NonNull P ctx = ((BasicPacketContext)PacketPhase.General.CLOSE_WINDOW.createPhaseContext(PhaseTracker.SERVER).source(this)).packetPlayer(player);){
            ((PhaseContext)ctx).buildAndSwitch();
            try (EffectTransactor ignored = ((PhaseContext)ctx).getTransactor().logCloseInventory((Player)player, true);){
                this.containerMenu.removed((Player)player);
                this.containerMenu.broadcastChanges();
            }
            if (!TrackingUtil.processBlockCaptures(ctx)) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }
}

