/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server.dedicated;

import net.minecraft.core.BlockPos;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={DedicatedServer.class})
public abstract class DedicatedServerMixin_Tracker {
    @Shadow
    public abstract int shadow$getSpawnProtectionRadius();

    @Overwrite
    public boolean isUnderSpawnProtection(ServerLevel worldIn, BlockPos pos, Player playerIn) {
        PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
        if (!context.isInteraction() && ShouldFire.CHANGE_BLOCK_EVENT_PRE && SpongeCommonEventFactory.callChangeBlockEventPre((ServerLevelBridge)worldIn, pos, (Object)playerIn).isCancelled()) {
            return true;
        }
        BlockPos spawnPoint = worldIn.getSharedSpawnPos();
        int protectionRadius = this.shadow$getSpawnProtectionRadius();
        return protectionRadius > 0 && Math.max(Math.abs(pos.getX() - spawnPoint.getX()), Math.abs(pos.getZ() - spawnPoint.getZ())) <= protectionRadius && !((ServerPlayer)playerIn).hasPermission("minecraft.spawn-protection.override");
    }
}

