/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.entity.player;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.entity.player.PlayerBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.tracker.world.entity.LivingEntityMixin_Tracker;

@Mixin(value={Player.class})
public abstract class PlayerMixin_Tracker
extends LivingEntityMixin_Tracker {
    @Shadow
    public abstract Component shadow$getDisplayName();

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    public void impl$callDestructEntityDeath(DamageSource cause, CallbackInfo ci) {
        DestructEntityEvent.Death event;
        if (this.shadow$isEffectiveAi() && (event = SpongeCommonEventFactory.callDestructEntityEventDeath((LivingEntity)((Player)this), cause)).isCancelled()) {
            ci.cancel();
        }
    }

    @Nullable
    @Overwrite
    public ItemEntity drop(ItemStack droppedItem, boolean dropAround, boolean traceItem) {
        if (droppedItem.isEmpty()) {
            return null;
        }
        if (!((LevelBridge)this.level).bridge$isFake()) {
            Player player = (Player)((PlayerBridge)((Object)this));
            double posX1 = player.getX();
            double posY1 = this.shadow$getEyeY() - (double)0.3f;
            double posZ1 = player.getZ();
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(droppedItem);
            ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
            original.add(snapshot);
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                ItemStack item = SpongeCommonEventFactory.throwDropItemAndConstructEvent((Entity)((Player)((PlayerBridge)((Object)this))), posX1, posY1, posZ1, snapshot, original, frame);
                if (item == null || item.isEmpty()) {
                    ItemEntity itemEntity = null;
                    return itemEntity;
                }
                ItemEntity itemEntity = new ItemEntity(player.level, posX1, posY1, posZ1, droppedItem);
                itemEntity.setPickUpDelay(40);
                if (traceItem) {
                    itemEntity.setThrower(player.getUUID());
                }
                Random random = player.getRandom();
                if (dropAround) {
                    float f = random.nextFloat() * 0.5f;
                    float f1 = random.nextFloat() * ((float)Math.PI * 2);
                    itemEntity.setDeltaMovement((double)(-Mth.sin((float)f1) * f), (double)0.2f, (double)(Mth.cos((float)f1) * f));
                } else {
                    float f8 = Mth.sin((float)(this.shadow$getXRot() * ((float)Math.PI / 180)));
                    float f2 = Mth.cos((float)(this.shadow$getXRot() * ((float)Math.PI / 180)));
                    float f3 = Mth.sin((float)(this.shadow$getYRot() * ((float)Math.PI / 180)));
                    float f4 = Mth.cos((float)(this.shadow$getYRot() * ((float)Math.PI / 180)));
                    float f5 = this.random.nextFloat() * ((float)Math.PI * 2);
                    float f6 = 0.02f * this.random.nextFloat();
                    itemEntity.setDeltaMovement((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, (double)(-f8 * 0.3f + 0.1f + (this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
                }
                ItemEntity itemEntity2 = itemEntity;
                return itemEntity2;
            }
        }
        this.shadow$swing(InteractionHand.MAIN_HAND);
        double d0 = this.shadow$getEyeY() - (double)0.3f;
        ItemEntity itemEntity = new ItemEntity(this.level, this.shadow$getX(), d0, this.shadow$getZ(), droppedItem);
        itemEntity.setPickUpDelay(40);
        if (traceItem) {
            itemEntity.setThrower(this.shadow$getUUID());
        }
        if (dropAround) {
            float f = this.random.nextFloat() * 0.5f;
            float f1 = this.random.nextFloat() * ((float)Math.PI * 2);
            itemEntity.setDeltaMovement((double)(-Mth.sin((float)f1) * f), (double)0.2f, (double)(Mth.cos((float)f1) * f));
        } else {
            float f8 = Mth.sin((float)(this.shadow$getXRot() * ((float)Math.PI / 180)));
            float f2 = Mth.cos((float)(this.shadow$getXRot() * ((float)Math.PI / 180)));
            float f3 = Mth.sin((float)(this.shadow$getYRot() * ((float)Math.PI / 180)));
            float f4 = Mth.cos((float)(this.shadow$getYRot() * ((float)Math.PI / 180)));
            float f5 = this.random.nextFloat() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.random.nextFloat();
            itemEntity.setDeltaMovement((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, (double)(-f8 * 0.3f + 0.1f + (this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        return itemEntity;
    }
}

