/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.level;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={Level.class})
public abstract class LevelMixin_Tracker
implements LevelBridge {
    @Shadow
    @Final
    public Random random;
    @Shadow
    @Final
    protected WritableLevelData levelData;

    @Shadow
    public abstract LevelChunk shadow$getChunkAt(BlockPos var1);

    @Shadow
    public abstract void shadow$guardEntityTick(Consumer<Entity> var1, Entity var2);

    @Shadow
    public boolean setBlock(BlockPos pos, BlockState state, int flags, int limit) {
        throw new IllegalStateException("Untransformed shadow!");
    }

    @Shadow
    public void shadow$removeBlockEntity(BlockPos pos) {
    }

    @Shadow
    @Nullable
    public abstract BlockEntity shadow$getBlockEntity(BlockPos var1);

    @Shadow
    public void shadow$setBlockEntity(BlockEntity tileEntity) {
    }

    @Shadow
    public void shadow$neighborChanged(BlockPos pos, Block blockIn, BlockPos fromPos) {
    }

    @Shadow
    public abstract BlockState shadow$getBlockState(BlockPos var1);

    @Shadow
    public abstract boolean shadow$isDebug();

    @Shadow
    public boolean destroyBlock(BlockPos p_241212_1_, boolean p_241212_2_, @Nullable Entity p_241212_3_, int p_241212_4_) {
        throw new IllegalStateException("Untransformed shadow!");
    }

    @Shadow
    public abstract FluidState shadow$getFluidState(BlockPos var1);

    @Redirect(method={"tickBlockEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/TickingBlockEntity;tick()V"))
    protected void tracker$wrapBlockEntityTick(TickingBlockEntity tileEntity) {
        tileEntity.tick();
    }

    @Inject(method={"getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;", "getEntities(Lnet/minecraft/world/level/entity/EntityTypeTest;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, at={@At(value="RETURN")})
    private void tracker$ThrowCollisionEvent(@Coerce Object entityIn, AABB aabb, Predicate<?> filter, CallbackInfoReturnable<List<Entity>> cir) {
        Entity entity;
        if (this.bridge$isFake() || !PhaseTracker.getInstance().getPhaseContext().allowsEntityCollisionEvents()) {
            return;
        }
        List ret = (List)cir.getReturnValue();
        if (ret == null || ret.isEmpty()) {
            return;
        }
        if (!ShouldFire.COLLIDE_ENTITY_EVENT) {
            return;
        }
        Entity entity2 = entity = entityIn instanceof Entity ? (Entity)entityIn : null;
        if (SpongeCommonEventFactory.callCollideEntityEvent(entity, ret).isCancelled()) {
            ret.clear();
        }
    }
}

