/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.RegistryBackedTrackableBridge;
import org.spongepowered.common.bridge.world.level.block.TrackableBlockBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.tracker.TrackerCategory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.util.ReflectionUtil;

@Mixin(value={Block.class})
public abstract class BlockMixin_Tracker
implements TrackableBlockBridge,
RegistryBackedTrackableBridge<Block> {
    private final boolean tracker$hasNeighborLogicOverridden = ReflectionUtil.isNeighborChangedDeclared(this.getClass());
    private final boolean tracker$hasEntityInsideLogicOverridden = ReflectionUtil.isEntityInsideDeclared(this.getClass());
    private static @Nullable EffectTransactor tracker$effectTransactorForDrops = null;

    @Override
    public boolean bridge$overridesNeighborNotificationLogic() {
        return this.tracker$hasNeighborLogicOverridden;
    }

    @Override
    public boolean bridge$hasEntityInsideLogic() {
        return this.tracker$hasEntityInsideLogicOverridden;
    }

    @Inject(method={"dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;)V", "dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void tracker$cancelOnBlockRestoration(CallbackInfo ci) {
        if (Thread.currentThread() == PhaseTracker.SERVER.getSidedThread() && PhaseTracker.SERVER.getPhaseContext().isRestoring()) {
            ci.cancel();
        }
    }

    @Inject(method={"dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")})
    private static void tracker$captureBlockProposedToBeSpawningDrops(BlockState state, Level worldIn, BlockPos pos, CallbackInfo ci) {
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            return;
        }
        PhaseContext<@NonNull ?> context = server.getPhaseContext();
        tracker$effectTransactorForDrops = context.getTransactor().logBlockDrops(worldIn, pos, state, null);
    }

    @Inject(method={"dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;)V"}, at={@At(value="HEAD")})
    private static void tracker$captureBlockProposedToBeSpawningDrops(BlockState state, LevelAccessor worldIn, BlockPos pos, @Nullable BlockEntity tileEntity, CallbackInfo ci) {
        if (!(worldIn instanceof Level)) {
            return;
        }
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            return;
        }
        PhaseContext<@NonNull ?> context = server.getPhaseContext();
        tracker$effectTransactorForDrops = context.getTransactor().logBlockDrops((Level)worldIn, pos, state, tileEntity);
    }

    @Inject(method={"dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")})
    private static void tracker$captureBlockProposedToBeSpawningDrops(BlockState state, Level worldIn, BlockPos pos, @Nullable BlockEntity tileEntity, Entity entity, ItemStack itemStack, CallbackInfo ci) {
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            return;
        }
        PhaseContext<@NonNull ?> context = server.getPhaseContext();
        tracker$effectTransactorForDrops = context.getTransactor().logBlockDrops(worldIn, pos, state, tileEntity);
    }

    @Inject(method={"dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;)V", "dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="TAIL")})
    private static void tracker$closeEffectIfCapturing(CallbackInfo ci) {
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            return;
        }
        PhaseContext<@NonNull ?> context = server.getPhaseContext();
        context.getTransactor().completeBlockDrops(tracker$effectTransactorForDrops);
    }

    @Override
    public TrackerCategory bridge$trackerCategory() {
        return SpongeGameConfigs.getTracker().get().block;
    }

    @Override
    public Registry<Block> bridge$trackerRegistryBacking() {
        return Registry.BLOCK;
    }

    @Override
    public void bridge$saveTrackerConfig() {
        SpongeGameConfigs.getTracker().save();
    }
}

