/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddPlayerPacket;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryPacket;
import net.minecraft.resources.ResourceLocation;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.common.accessor.network.protocol.game.ClientboundAddPlayerPacketAccessor;

public final class PacketUtil {
    private static final Object UNSAFE;
    private static final MethodHandle ALLOCATE_INSTANCE;

    public static Packet<?> createLoginPayloadResponse(@Nullable ChannelBuf payload, int transactionId) {
        return new ServerboundCustomQueryPacket(transactionId, (FriendlyByteBuf)payload);
    }

    public static Packet<?> createLoginPayloadRequest(ResourceKey channel, ChannelBuf payload, int transactionId) {
        return new ClientboundCustomQueryPacket(transactionId, (ResourceLocation)channel, (FriendlyByteBuf)payload);
    }

    public static Packet<?> createPlayPayload(ResourceKey channel, ChannelBuf payload, EngineConnectionSide<?> side) {
        if (side == EngineConnectionSide.CLIENT) {
            return new ServerboundCustomPayloadPacket((ResourceLocation)channel, (FriendlyByteBuf)payload);
        }
        if (side == EngineConnectionSide.SERVER) {
            return new ClientboundCustomPayloadPacket((ResourceLocation)channel, (FriendlyByteBuf)payload);
        }
        throw new UnsupportedOperationException();
    }

    public static ClientboundAddPlayerPacket createClientboundAddPlayerPacket(int entityId, UUID playerId, double x, double y, double z, byte yRot, byte xRot) {
        ClientboundAddPlayerPacket packet = PacketUtil.createPacketWithoutConstructor(ClientboundAddPlayerPacket.class);
        ClientboundAddPlayerPacketAccessor accessor = (ClientboundAddPlayerPacketAccessor)packet;
        accessor.accessor$entityId(entityId);
        accessor.accessor$playerId(playerId);
        accessor.accessor$x(x);
        accessor.accessor$y(y);
        accessor.accessor$z(z);
        accessor.accessor$yRot(yRot);
        accessor.accessor$xRot(xRot);
        return packet;
    }

    public static <P extends org.spongepowered.api.network.channel.packet.Packet> Supplier<P> getConstructor(Class<P> packetClass) {
        Constructor constructor;
        try {
            constructor = packetClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        return () -> {
            try {
                return (org.spongepowered.api.network.channel.packet.Packet)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        };
    }

    private static <P extends Packet<?>> @NonNull P createPacketWithoutConstructor(@NonNull Class<P> packet) {
        try {
            return (P)ALLOCATE_INSTANCE.invoke(UNSAFE, packet);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to create instance of packet " + packet, ex);
        }
    }

    private PacketUtil() {
    }

    static {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            UNSAFE = unsafeField.get(null);
            ALLOCATE_INSTANCE = MethodHandles.lookup().findVirtual(unsafeClass, "allocateInstance", MethodType.methodType(Object.class, Class.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException ex) {
            throw new ExceptionInInitializerError("Unable to access Unsafe instance!");
        }
    }
}

