/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.common.network.channel.ChannelBuffers;

public final class ChannelBufferAllocator {
    public static final ChannelBufferAllocator UNPOOLED = new ChannelBufferAllocator((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
    public static final ChannelBufferAllocator POOLED = new ChannelBufferAllocator((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
    private final ByteBufAllocator allocator;

    public ChannelBufferAllocator(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    public ChannelBuf buffer() {
        return ChannelBuffers.wrap(this.allocator.buffer());
    }

    public ChannelBuf buffer(int initialCapacity) {
        return ChannelBuffers.wrap(this.allocator.buffer(initialCapacity));
    }

    public ChannelBuf heapBuffer() {
        return ChannelBuffers.wrap(this.allocator.heapBuffer());
    }

    public ChannelBuf heapBuffer(int initialCapacity) {
        return ChannelBuffers.wrap(this.allocator.heapBuffer(initialCapacity));
    }

    public ChannelBuf directBuffer() {
        return ChannelBuffers.wrap(this.allocator.directBuffer());
    }

    public ChannelBuf directBuffer(int initialCapacity) {
        return ChannelBuffers.wrap(this.allocator.directBuffer(initialCapacity));
    }
}

