/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.inject.Singleton;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryPacket;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.channel.Channel;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.ChannelManager;
import org.spongepowered.api.network.channel.NoResponseException;
import org.spongepowered.api.network.channel.packet.PacketChannel;
import org.spongepowered.api.network.channel.packet.basic.BasicPacketChannel;
import org.spongepowered.api.network.channel.raw.RawDataChannel;
import org.spongepowered.api.registry.DuplicateRegistrationException;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.bridge.client.MinecraftBridge;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.entity.player.ClientType;
import org.spongepowered.common.network.PacketUtil;
import org.spongepowered.common.network.channel.ChannelBufferAllocator;
import org.spongepowered.common.network.channel.ChannelBuffers;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.RegisterChannelUtil;
import org.spongepowered.common.network.channel.SpongeChannel;
import org.spongepowered.common.network.channel.TransactionResult;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.network.channel.packet.SpongeBasicPacketChannel;
import org.spongepowered.common.network.channel.packet.SpongePacketChannel;
import org.spongepowered.common.network.channel.raw.SpongeRawDataChannel;
import org.spongepowered.common.util.Constants;

@Singleton
public final class SpongeChannelManager
implements ChannelManager {
    private final Map<ResourceKey, SpongeChannel> channels = new HashMap<ResourceKey, SpongeChannel>();
    private final Map<Class<?>, Tuple<Integer, CreateFunction<SpongeChannel>>> channelBuilders = new HashMap();
    private final ChannelBufferAllocator bufferAllocator;

    public SpongeChannelManager(ChannelBufferAllocator bufferAllocator) {
        this.bufferAllocator = bufferAllocator;
        this.registerChannelType(0, RawDataChannel.class, SpongeRawDataChannel::new);
        this.registerChannelType(1, PacketChannel.class, SpongePacketChannel::new);
        this.registerChannelType(2, BasicPacketChannel.class, SpongeBasicPacketChannel::new);
    }

    public ChannelBufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    private <T extends Channel> void registerChannelType(int id, Class<T> channelType, CreateFunction<? extends T> builder) {
        this.channelBuilders.put(channelType, Tuple.of(id, builder));
    }

    public <C extends Channel> C createChannel(ResourceKey channelKey, Class<C> channelType) throws DuplicateRegistrationException {
        Objects.requireNonNull(channelKey, "channelKey");
        Objects.requireNonNull(channelType, "channelType");
        if (this.channels.containsKey(channelKey)) {
            throw new DuplicateRegistrationException("The channel key \"" + channelKey + "\" is already in use.");
        }
        Tuple<Integer, CreateFunction<SpongeChannel>> tuple = this.channelBuilders.get(channelType);
        if (tuple == null) {
            throw new IllegalArgumentException("Unsupported channel type: " + channelType);
        }
        SpongeChannel channel = tuple.second().create(tuple.first(), channelKey, this);
        this.channels.put(channelKey, channel);
        return (C)channel;
    }

    @Override
    public Optional<Channel> get(ResourceKey channelKey) {
        Objects.requireNonNull(channelKey, "channelKey");
        return Optional.ofNullable((Channel)this.channels.get(channelKey));
    }

    @Override
    public <C extends Channel> C ofType(ResourceKey channelKey, Class<C> channelType) {
        Objects.requireNonNull(channelKey, "channelKey");
        Objects.requireNonNull(channelType, "channelType");
        Channel binding = this.channels.get(channelKey);
        if (binding != null) {
            if (!channelType.isInstance(binding)) {
                throw new IllegalStateException("There's already a channel registered for " + channelKey + ", but it is not of the requested type " + channelType);
            }
            return (C)binding;
        }
        return this.createChannel(channelKey, channelType);
    }

    @Override
    public Collection<Channel> channels() {
        return ImmutableList.copyOf(this.channels.values());
    }

    public CompletableFuture<Void> requestClientType(EngineConnection connection) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        TransactionStore store = ConnectionUtil.getTransactionStore(connection);
        int transactionId = store.nextId();
        store.put(transactionId, null, new ClientTypeSyncFuture(future));
        ChannelBuf payload = this.bufferAllocator.buffer();
        Packet<?> mcPacket = PacketUtil.createLoginPayloadRequest(Constants.Channels.SPONGE_CLIENT_TYPE, payload, transactionId);
        PacketSender.sendTo(connection, mcPacket, sendFuture -> {
            if (!sendFuture.isSuccess()) {
                future.completeExceptionally(sendFuture.cause());
            }
        });
        return future;
    }

    private void handleClientType(EngineConnection connection, ChannelBuf payload) {
        ClientType clientType = ClientType.from(payload.readString());
        if (clientType == null) {
            return;
        }
        ((ConnectionBridge)((ServerLoginPacketListenerImpl)connection).connection).bridge$setClientType(clientType);
    }

    public CompletableFuture<Void> sendLoginChannelRegistry(EngineConnection connection) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        TransactionStore store = ConnectionUtil.getTransactionStore(connection);
        int transactionId = store.nextId();
        store.put(transactionId, null, new ChannelRegistrySyncFuture(future));
        ChannelBuf payload = this.encodeChannelRegistry();
        Packet<?> mcPacket = PacketUtil.createLoginPayloadRequest(Constants.Channels.SPONGE_CHANNEL_REGISTRY, payload, transactionId);
        PacketSender.sendTo(connection, mcPacket, sendFuture -> {
            if (!sendFuture.isSuccess()) {
                future.completeExceptionally(sendFuture.cause());
            }
        });
        return future;
    }

    public void sendChannelRegistrations(EngineConnection connection) {
        ChannelBuf payload = RegisterChannelUtil.encodePayload(this.channels.keySet());
        Packet<?> mcPacket = PacketUtil.createPlayPayload(Constants.Channels.REGISTER_KEY, payload, connection.side());
        PacketSender.sendTo(connection, mcPacket);
    }

    private ChannelBuf encodeChannelRegistry() {
        ImmutableList channels = ImmutableList.copyOf(this.channels.values());
        ChannelBuf buf = this.bufferAllocator.buffer();
        buf.writeVarInt(channels.size());
        for (SpongeChannel channel : channels) {
            buf.writeString(channel.key().formatted());
            buf.writeByte((byte)channel.getType());
        }
        return buf;
    }

    private void handleChannelRegistry(EngineConnection connection, ChannelBuf payload) {
        Set<ResourceKey> registered = ConnectionUtil.getRegisteredChannels(connection);
        registered.clear();
        int count = payload.readVarInt();
        for (int i = 0; i < count; ++i) {
            ResourceKey key = ResourceKey.resolve(payload.readString());
            payload.readByte();
            registered.add(key);
        }
    }

    public boolean handlePlayPayload(EngineConnection connection, ServerboundCustomPayloadPacket packet) {
        ResourceKey channel = (ResourceKey)packet.getIdentifier();
        ChannelBuf payload = (ChannelBuf)packet.getData();
        return this.handlePlayPayload(connection, channel, payload);
    }

    public boolean handlePlayPayload(EngineConnection connection, ClientboundCustomPayloadPacket packet) {
        ResourceKey channel = (ResourceKey)packet.getIdentifier();
        ChannelBuf payload = (ChannelBuf)packet.getData();
        return this.handlePlayPayload(connection, channel, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegisterChannel(EngineConnection connection, ChannelBuf payload, BiConsumer<Set<ResourceKey>, List<ResourceKey>> consumer) {
        Set<ResourceKey> registered = ConnectionUtil.getRegisteredChannels(connection);
        int readerIndex = payload.readerIndex();
        try {
            List<ResourceKey> modified = RegisterChannelUtil.decodePayload(payload);
            consumer.accept(registered, modified);
        }
        finally {
            payload.readerIndex(readerIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handlePlayPayload(EngineConnection connection, ResourceKey channelKey, ChannelBuf payload) {
        if (channelKey.equals(Constants.Channels.SPONGE_CLIENT_TYPE)) {
            this.handleClientType(connection, payload);
            return true;
        }
        if (channelKey.equals(Constants.Channels.SPONGE_CHANNEL_REGISTRY)) {
            this.handleChannelRegistry(connection, payload);
            return true;
        }
        if (channelKey.equals(Constants.Channels.REGISTER_KEY)) {
            this.handleRegisterChannel(connection, payload, Set::addAll);
            return true;
        }
        if (channelKey.equals(Constants.Channels.UNREGISTER_KEY)) {
            this.handleRegisterChannel(connection, payload, Set::removeAll);
            return true;
        }
        SpongeChannel channel = this.channels.get(channelKey);
        if (channel != null) {
            try {
                channel.handlePlayPayload(connection, payload);
            }
            finally {
                ChannelBuffers.release(payload);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleLoginRequestPayload(EngineConnection connection, ClientboundCustomQueryPacket packet) {
        ResourceKey channel = (ResourceKey)packet.getIdentifier();
        int transactionId = packet.getTransactionId();
        ChannelBuf payload = (ChannelBuf)packet.getData();
        try {
            boolean bl = this.handleLoginRequestPayload(connection, channel, transactionId, payload);
            return bl;
        }
        finally {
            ChannelBuffers.release(payload);
        }
    }

    private boolean handleLoginRequestPayload(EngineConnection connection, ResourceKey channelKey, int transactionId, ChannelBuf payload) {
        SpongeChannel channel;
        if (channelKey.equals(Constants.Channels.SPONGE_CLIENT_TYPE)) {
            ClientType clientType = ((MinecraftBridge)((Object)Sponge.client())).bridge$getClientType();
            ChannelBuf responsePayload = this.bufferAllocator.buffer();
            responsePayload.writeString(clientType.getName());
            Packet<?> mcPacket = PacketUtil.createLoginPayloadResponse(responsePayload, transactionId);
            PacketSender.sendTo(connection, mcPacket);
            return true;
        }
        if (channelKey.equals(Constants.Channels.SPONGE_CHANNEL_REGISTRY)) {
            this.handleChannelRegistry(connection, payload);
            ChannelBuf responsePayload = this.encodeChannelRegistry();
            Packet<?> mcPacket = PacketUtil.createLoginPayloadResponse(responsePayload, transactionId);
            PacketSender.sendTo(connection, mcPacket);
            return true;
        }
        ResourceKey actualChannelKey = channelKey;
        ChannelBuf actualPayload = payload;
        if (channelKey.equals(Constants.Channels.FML_LOGIN_WRAPPER_CHANNEL)) {
            actualChannelKey = ResourceKey.resolve(payload.readString());
            int length = payload.readVarInt();
            actualPayload = payload.readSlice(length);
        }
        if ((channel = this.channels.get(actualChannelKey)) != null) {
            channel.handleLoginRequestPayload(connection, transactionId, actualPayload);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLoginResponsePayload(EngineConnection connection, ServerboundCustomQueryPacket packet) {
        int transactionId = packet.getTransactionId();
        ChannelBuf payload = (ChannelBuf)packet.getData();
        try {
            this.handleLoginResponsePayload(connection, transactionId, payload);
        }
        finally {
            if (payload != null) {
                ChannelBuffers.release(payload);
            }
        }
    }

    private void handleLoginResponsePayload(EngineConnection connection, int transactionId, @Nullable ChannelBuf payload) {
        if (transactionId == 0x7FFFFFFE) {
            return;
        }
        if (transactionId == Integer.MAX_VALUE) {
            if (payload != null) {
                ResourceKey channelKey = ResourceKey.resolve(payload.readString());
                this.handlePlayPayload(connection, channelKey, payload);
            }
            return;
        }
        TransactionStore transactionStore = ConnectionUtil.getTransactionStore(connection);
        TransactionStore.Entry entry = transactionStore.remove(transactionId);
        if (entry == null) {
            return;
        }
        if (entry.getData() instanceof ClientTypeSyncFuture) {
            if (payload != null) {
                this.handleClientType(connection, payload);
            }
            ((ClientTypeSyncFuture)entry.getData()).future.complete(null);
            return;
        }
        if (entry.getData() instanceof ChannelRegistrySyncFuture) {
            if (payload != null) {
                this.handleChannelRegistry(connection, payload);
            }
            ((ChannelRegistrySyncFuture)entry.getData()).future.complete(null);
            return;
        }
        TransactionResult result = payload == null ? TransactionResult.failure(new NoResponseException()) : TransactionResult.success(payload);
        entry.getChannel().handleTransactionResponse(connection, entry.getData(), result);
    }

    static interface CreateFunction<C extends Channel> {
        public C create(int var1, ResourceKey var2, SpongeChannelManager var3);
    }

    private static final class ClientTypeSyncFuture {
        private final CompletableFuture<Void> future;

        private ClientTypeSyncFuture(CompletableFuture<Void> future) {
            this.future = future;
        }
    }

    private static final class ChannelRegistrySyncFuture {
        private final CompletableFuture<Void> future;

        private ChannelRegistrySyncFuture(CompletableFuture<Void> future) {
            this.future = future;
        }
    }
}

