/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel.packet;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.ChannelException;
import org.spongepowered.api.network.channel.ChannelIOException;
import org.spongepowered.api.network.channel.NoResponseException;
import org.spongepowered.api.network.channel.packet.PacketChannel;
import org.spongepowered.api.network.channel.packet.RequestPacket;
import org.spongepowered.api.network.channel.packet.RequestPacketHandler;
import org.spongepowered.common.network.PacketUtil;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.channel.TransactionResult;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.network.channel.packet.AbstractPacketChannel;
import org.spongepowered.common.network.channel.packet.SpongeFixedTransactionalPacketBinding;
import org.spongepowered.common.network.channel.packet.SpongeHandlerPacketBinding;
import org.spongepowered.common.network.channel.packet.SpongePacketBinding;
import org.spongepowered.common.network.channel.packet.SpongeRequestPacketResponse;
import org.spongepowered.common.network.channel.packet.SpongeTransactionalPacketBinding;

public class SpongePacketChannel
extends AbstractPacketChannel
implements PacketChannel {
    static final int TYPE_NORMAL = 0;
    static final int TYPE_REQUEST = 1;
    static final int TYPE_RESPONSE = 2;
    static final int TYPE_NO_RESPONSE = 3;
    static final int TYPE_DYNAMIC_RESPONSE = 4;
    static final int TYPE_BITS = 3;
    static final int TYPE_MASK = 7;
    static final int NO_DYNAMIC_OPCODE = -1;

    public SpongePacketChannel(int type, ResourceKey key, SpongeChannelManager manager) {
        super(type, key, manager);
    }

    private <P extends RequestPacket<R>, R extends org.spongepowered.api.network.channel.packet.Packet> void sendRequestPacketTo(EngineConnection connection, P packet, CompletableFuture<?> future, @Nullable Consumer<R> response, @Nullable Runnable sendSuccess) {
        Supplier<Packet> mcPacketSupplier;
        SpongeTransactionalPacketBinding binding = (SpongeTransactionalPacketBinding)this.requireBinding(packet.getClass());
        TransactionStore transactionStore = ConnectionUtil.getTransactionStore(connection);
        int transactionId = transactionStore.nextId();
        boolean isLoginPhase = ConnectionUtil.isLoginPhase(connection);
        EngineConnectionSide<? extends EngineConnection> side = connection.side();
        ChannelBuf payload = this.manager().getBufferAllocator().buffer();
        if (isLoginPhase) {
            if (side == EngineConnectionSide.CLIENT) {
                payload.writeString(this.key().formatted());
                payload.writeVarLong(SpongePacketChannel.packTypeAndValue(1, transactionId));
                payload.writeVarInt(binding.opcode());
                mcPacketSupplier = () -> PacketUtil.createLoginPayloadResponse(payload, Integer.MAX_VALUE);
            } else {
                payload.writeVarLong(SpongePacketChannel.packTypeAndValue(1, binding.opcode()));
                mcPacketSupplier = () -> PacketUtil.createLoginPayloadRequest(this.key(), payload, transactionId);
            }
        } else {
            payload.writeVarLong(SpongePacketChannel.packTypeAndValue(1, transactionId));
            payload.writeVarInt(binding.opcode());
            mcPacketSupplier = () -> PacketUtil.createPlayPayload(this.key(), payload, side);
        }
        try {
            this.encodePayload(payload, packet);
        }
        catch (Throwable ex) {
            this.handleException(connection, ex, future);
            return;
        }
        if (response != null) {
            AbstractPacketChannel.TransactionData<P, R> transactionData = new AbstractPacketChannel.TransactionData<P, R>(packet, binding, response, future);
            transactionStore.put(transactionId, this, transactionData);
        }
        Packet mcPacket = mcPacketSupplier.get();
        PacketSender.sendTo(connection, mcPacket, sendFuture -> {
            if (!sendFuture.isSuccess()) {
                this.handleException(connection, sendFuture.cause(), future);
                if (response != null) {
                    transactionStore.remove(transactionId);
                }
            } else if (sendSuccess != null) {
                sendSuccess.run();
            }
        });
    }

    private <P extends RequestPacket<R>, R extends org.spongepowered.api.network.channel.packet.Packet> void sendResponsePacketTo(EngineConnection connection, @Nullable SpongeTransactionalPacketBinding<P, R> requestBinding, @Nullable R packet, int transactionId) {
        Supplier<Packet> mcPacketSupplier;
        boolean isLoginPhase = ConnectionUtil.isLoginPhase(connection);
        EngineConnectionSide<? extends EngineConnection> side = connection.side();
        ChannelBuf payload = this.manager().getBufferAllocator().buffer();
        if (packet == null || requestBinding instanceof SpongeFixedTransactionalPacketBinding) {
            int type;
            int n = type = packet == null ? 3 : 2;
            if (isLoginPhase) {
                if (side == EngineConnectionSide.CLIENT) {
                    payload.writeVarLong(SpongePacketChannel.packTypeAndValue(type, 0));
                    mcPacketSupplier = () -> PacketUtil.createLoginPayloadResponse(payload, transactionId);
                } else {
                    payload.writeVarLong(SpongePacketChannel.packTypeAndValue(type, transactionId));
                    mcPacketSupplier = () -> PacketUtil.createLoginPayloadRequest(this.key(), payload, Integer.MAX_VALUE);
                }
            } else {
                payload.writeVarLong(SpongePacketChannel.packTypeAndValue(type, transactionId));
                mcPacketSupplier = () -> PacketUtil.createPlayPayload(this.key(), payload, side);
            }
        } else {
            int opcode = this.requireBinding(packet.getClass()).opcode();
            if (isLoginPhase) {
                if (side == EngineConnectionSide.CLIENT) {
                    payload.writeVarLong(SpongePacketChannel.packTypeAndValue(4, opcode));
                    mcPacketSupplier = () -> PacketUtil.createLoginPayloadResponse(payload, transactionId);
                } else {
                    payload.writeVarLong(SpongePacketChannel.packTypeAndValue(4, transactionId));
                    payload.writeVarInt(opcode);
                    mcPacketSupplier = () -> PacketUtil.createLoginPayloadRequest(this.key(), payload, Integer.MAX_VALUE);
                }
            } else {
                payload.writeVarLong(SpongePacketChannel.packTypeAndValue(4, transactionId));
                payload.writeVarInt(opcode);
                mcPacketSupplier = () -> PacketUtil.createPlayPayload(this.key(), payload, side);
            }
        }
        try {
            this.encodePayload(payload, packet);
        }
        catch (Throwable ex) {
            this.handleException(connection, new ChannelIOException("Failed to encode request response", ex), null);
            return;
        }
        Packet mcPacket = mcPacketSupplier.get();
        PacketSender.sendTo(connection, mcPacket);
    }

    private <P extends org.spongepowered.api.network.channel.packet.Packet> void sendNormalPacketTo(EngineConnection connection, P packet, CompletableFuture<Void> future) {
        Supplier<Packet> mcPacketSupplier;
        SpongePacketBinding<org.spongepowered.api.network.channel.packet.Packet> binding = this.requireBinding(packet.getClass());
        boolean isLoginPhase = ConnectionUtil.isLoginPhase(connection);
        EngineConnectionSide<? extends EngineConnection> side = connection.side();
        ChannelBuf payload = this.manager().getBufferAllocator().buffer();
        if (isLoginPhase) {
            if (side == EngineConnectionSide.CLIENT) {
                payload.writeString(this.key().formatted());
                payload.writeVarLong(SpongePacketChannel.packTypeAndValue(0, binding.opcode()));
                mcPacketSupplier = () -> PacketUtil.createLoginPayloadResponse(payload, Integer.MAX_VALUE);
            } else {
                payload.writeVarLong(SpongePacketChannel.packTypeAndValue(0, binding.opcode()));
                int transactionId = ConnectionUtil.getTransactionStore(connection).nextId();
                mcPacketSupplier = () -> PacketUtil.createLoginPayloadRequest(this.key(), payload, transactionId);
            }
        } else {
            payload.writeVarLong(SpongePacketChannel.packTypeAndValue(0, binding.opcode()));
            mcPacketSupplier = () -> PacketUtil.createPlayPayload(this.key(), payload, side);
        }
        try {
            this.encodePayload(payload, packet);
        }
        catch (Throwable ex) {
            future.completeExceptionally(ex);
            return;
        }
        Packet mcPacket = mcPacketSupplier.get();
        PacketSender.sendTo(connection, mcPacket, future);
    }

    @Override
    public <R extends org.spongepowered.api.network.channel.packet.Packet> CompletableFuture<R> sendTo(EngineConnection connection, RequestPacket<R> packet) {
        CompletableFuture future = new CompletableFuture();
        if (!this.checkSupported(connection, future)) {
            return future;
        }
        this.sendRequestPacketTo(connection, packet, future, future::complete, null);
        return future;
    }

    @Override
    public boolean isSupportedBy(EngineConnection connection) {
        Objects.requireNonNull(connection, "connection");
        return ConnectionUtil.getRegisteredChannels(connection).contains(this.key());
    }

    @Override
    public CompletableFuture<Void> sendTo(EngineConnection connection, org.spongepowered.api.network.channel.packet.Packet packet) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (!this.checkSupported(connection, future)) {
            return future;
        }
        if (packet instanceof RequestPacket) {
            this.sendRequestPacketTo(connection, (RequestPacket)packet, future, null, () -> future.complete(null));
        } else {
            this.sendNormalPacketTo(connection, packet, future);
        }
        return future;
    }

    private void handleResponsePacket(EngineConnection connection, int transactionId, @Nullable ChannelBuf payload, int dynamicOpcode) {
        TransactionStore store = ConnectionUtil.getTransactionStore(connection);
        TransactionStore.Entry stored = store.remove(transactionId);
        if (stored == null) {
            return;
        }
        AbstractPacketChannel.TransactionData transactionData = (AbstractPacketChannel.TransactionData)stored.getData();
        TransactionResult result = payload == null ? TransactionResult.failure(new NoResponseException()) : TransactionResult.success(payload);
        this.handleTransactionResponse(connection, transactionData, result, dynamicOpcode);
    }

    private <C extends EngineConnection> void handleRequestPacket(final C connection, int opcode, final int transactionId, ChannelBuf payload) {
        RequestPacketHandler<RequestPacket, org.spongepowered.api.network.channel.packet.Packet, C> handler;
        org.spongepowered.api.network.channel.packet.Packet request;
        final SpongePacketBinding<org.spongepowered.api.network.channel.packet.Packet> binding = this.requireBinding(opcode);
        try {
            request = this.decodePayload(binding.getPacketConstructor(), payload);
        }
        catch (Throwable ex) {
            this.sendResponsePacketTo(connection, null, null, transactionId);
            this.handleException(connection, new ChannelIOException("Failed to decode request packet", ex), null);
            return;
        }
        boolean success = false;
        Throwable responseFailure = null;
        if (binding instanceof SpongeTransactionalPacketBinding && (handler = ((SpongeTransactionalPacketBinding)binding).getRequestHandler(connection)) != null) {
            SpongeRequestPacketResponse<org.spongepowered.api.network.channel.packet.Packet> requestPacketResponse = new SpongeRequestPacketResponse<org.spongepowered.api.network.channel.packet.Packet>(){

                @Override
                protected void fail0(ChannelException exception) {
                    SpongePacketChannel.this.sendResponsePacketTo(connection, null, null, transactionId);
                }

                @Override
                protected void success0(org.spongepowered.api.network.channel.packet.Packet response) {
                    SpongePacketChannel.this.sendResponsePacketTo(connection, (SpongeTransactionalPacketBinding)binding, response, transactionId);
                }
            };
            try {
                handler.handleRequest((RequestPacket)request, connection, requestPacketResponse);
                success = true;
            }
            catch (Throwable ex) {
                this.handleException(connection, new ChannelException("Failed to handle request packet", ex), null);
                responseFailure = ex;
            }
        }
        if (!success) {
            this.sendResponsePacketTo(connection, null, null, transactionId);
        }
    }

    private void handleNormalPacket(EngineConnection connection, int opcode, ChannelBuf payload) {
        SpongePacketBinding<org.spongepowered.api.network.channel.packet.Packet> binding = this.requireBinding(opcode);
        org.spongepowered.api.network.channel.packet.Packet packet = this.decodePayload(binding.getPacketConstructor(), payload);
        if (binding instanceof SpongeHandlerPacketBinding) {
            this.handle(connection, (SpongeHandlerPacketBinding)binding, packet);
        }
    }

    @Override
    protected void handlePlayPayload(EngineConnection connection, ChannelBuf payload) {
        long typeAndValue = payload.readVarLong();
        int type = SpongePacketChannel.extractType(typeAndValue);
        int value = SpongePacketChannel.extractValue(typeAndValue);
        if (type == 0) {
            this.handleNormalPacket(connection, value, payload);
        } else if (type == 1) {
            int opcode = payload.readVarInt();
            this.handleRequestPacket(connection, opcode, value, payload);
        } else if (type == 2) {
            this.handleResponsePacket(connection, value, payload, -1);
        } else if (type == 3) {
            this.handleResponsePacket(connection, value, null, -1);
        } else if (type == 4) {
            int opcode = payload.readVarInt();
            this.handleResponsePacket(connection, value, payload, opcode);
        } else {
            this.handleException(connection, new ChannelIOException("Unknown packet type: " + type), null);
        }
    }

    @Override
    protected void handleLoginRequestPayload(EngineConnection connection, int transactionId, ChannelBuf payload) {
        long typeAndValue = payload.readVarLong();
        int type = SpongePacketChannel.extractType(typeAndValue);
        int value = SpongePacketChannel.extractValue(typeAndValue);
        if (type == 0) {
            this.handleNormalPacket(connection, value, payload);
        } else if (type == 1) {
            this.handleRequestPacket(connection, value, transactionId, payload);
        } else if (type == 2) {
            this.handleResponsePacket(connection, transactionId, payload, -1);
        } else if (type == 3) {
            this.handleResponsePacket(connection, transactionId, null, -1);
        } else if (type == 4) {
            this.handleResponsePacket(connection, transactionId, payload, value);
        } else {
            this.handleException(connection, new ChannelIOException("Unknown packet type: " + type), null);
        }
    }

    @Override
    protected void handleTransactionResponse(EngineConnection connection, Object stored, TransactionResult result) {
        if (result.isSuccess()) {
            ChannelBuf payload = result.getPayload();
            long typeAndValue = payload.readVarLong();
            int type = SpongePacketChannel.extractType(typeAndValue);
            int value = SpongePacketChannel.extractValue(typeAndValue);
            if (type == 2 || type == 3 || type == 4) {
                AbstractPacketChannel.TransactionData transactionData = (AbstractPacketChannel.TransactionData)stored;
                if (type == 2) {
                    this.handleTransactionResponse(connection, transactionData, result, -1);
                } else if (type == 3) {
                    this.handleTransactionResponse(connection, transactionData, TransactionResult.failure(new NoResponseException()), -1);
                } else {
                    this.handleTransactionResponse(connection, transactionData, result, value);
                }
            } else {
                this.handleException(connection, new ChannelIOException("Unknown packet type: " + type), null);
            }
        }
    }

    private <P extends RequestPacket<R>, R extends org.spongepowered.api.network.channel.packet.Packet> void handleTransactionResponse(EngineConnection connection, AbstractPacketChannel.TransactionData<P, R> transactionData, TransactionResult result, int dynamicOpcode) {
        if (result.isSuccess()) {
            org.spongepowered.api.network.channel.packet.Packet packet;
            Supplier<org.spongepowered.api.network.channel.packet.Packet> packetSupplier;
            ChannelBuf payload = result.getPayload();
            SpongePacketBinding<org.spongepowered.api.network.channel.packet.Packet> responseBinding = null;
            if (dynamicOpcode != -1) {
                responseBinding = this.requireBinding(dynamicOpcode);
                packetSupplier = responseBinding.getPacketConstructor();
            } else if (transactionData.binding instanceof SpongeFixedTransactionalPacketBinding) {
                packetSupplier = ((SpongeFixedTransactionalPacketBinding)transactionData.binding).getResponsePacketConstructor();
            } else {
                throw new ChannelException("A fixed response was send but no fixed response was bound to the request: " + transactionData.request.getClass());
            }
            try {
                packet = this.decodePayload(packetSupplier, payload);
            }
            catch (Throwable ex) {
                this.handleException(connection, new ChannelIOException("Failed to decode packet", ex), transactionData.future);
                return;
            }
            if (responseBinding != null) {
                this.handle(connection, (SpongeHandlerPacketBinding)responseBinding, packet);
            } else {
                this.handleResponse(connection, transactionData.binding, transactionData.request, packet);
            }
            if (transactionData.success != null) {
                transactionData.success.accept(packet);
            }
        } else {
            this.handleException(connection, result.getCause(), transactionData.future);
            this.handleResponseFailure(connection, transactionData.binding, transactionData.request, result.getCause());
        }
    }

    private static long packTypeAndValue(int type, int value) {
        return type | value << 3;
    }

    private static int extractType(long typeAndValue) {
        return (int)(typeAndValue & 7L);
    }

    private static int extractValue(long typeAndValue) {
        return (int)(typeAndValue >>> 3);
    }
}

