/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.ClassUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.launch.Launch;

public final class ReflectionUtil {
    public static final Marker REFLECTION_SCANNING = MarkerManager.getMarker((String)"REFLECTION_SCANNING");
    private static final Class<?>[] NEIGHBOR_CHANGED_METHOD_ARGS = new Class[]{BlockState.class, Level.class, BlockPos.class, Block.class, BlockPos.class, Boolean.TYPE};
    private static final Class<?>[] ENTITY_INSIDE_METHOD_ARGS = new Class[]{BlockState.class, Level.class, BlockPos.class, Entity.class};
    private static final Class<?>[] STEP_ON_METHOD_ARGS = new Class[]{Level.class, BlockPos.class, BlockState.class, Entity.class};
    private static final Class<?>[] PLAYER_TOUCH_METHOD_ARGS = new Class[]{Player.class};

    public static boolean isNeighborChangedDeclared(Class<?> targetClass) {
        return ReflectionUtil.doesMethodExist(targetClass, Block.class, "neighborChanged", NEIGHBOR_CHANGED_METHOD_ARGS);
    }

    public static boolean isEntityInsideDeclared(Class<?> targetClass) {
        return ReflectionUtil.doesMethodExist(targetClass, BlockBehaviour.class, "entityInside", ENTITY_INSIDE_METHOD_ARGS);
    }

    public static boolean isStepOnDeclared(Class<?> targetClass) {
        return ReflectionUtil.doesMethodExist(targetClass, Block.class, "stepOn", STEP_ON_METHOD_ARGS);
    }

    public static boolean isPlayerTouchDeclared(Class<?> targetClass) {
        return ReflectionUtil.doesMethodExist(targetClass, Entity.class, "playerTouch", PLAYER_TOUCH_METHOD_ARGS);
    }

    public static boolean doesMethodExist(Class<?> targetClass, Class<?> ignoredClass, String methodName, Class<?>[] methodParameters) {
        String targetMethodForEnvironment = ((Launch)Launch.instance()).mappingManager().toRuntimeMethodName(targetClass, methodName, methodParameters);
        try {
            Class<?> declaringClass = targetClass.getMethod(targetMethodForEnvironment, methodParameters).getDeclaringClass();
            return !ignoredClass.equals(declaringClass);
        }
        catch (NoSuchMethodException e) {
            SpongeCommon.logger().fatal(REFLECTION_SCANNING, "Could not find desired method {} in class {} under environment method name {}", (Object)methodName, (Object)targetClass.getSimpleName(), (Object)targetMethodForEnvironment);
            return true;
        }
        catch (NoClassDefFoundError e) {
            SpongeCommon.logger().fatal(REFLECTION_SCANNING, "Failed to load class in {} while scanning desired method {} under environment method name {}", targetClass, (Object)methodName, (Object)targetMethodForEnvironment);
            return true;
        }
    }

    public static <T> T createInstance(Class<T> objectClass, Object ... args) {
        Preconditions.checkArgument((!Modifier.isAbstract(objectClass.getModifiers()) ? 1 : 0) != 0, (Object)"Cannot construct an instance of an abstract class!");
        Preconditions.checkArgument((!Modifier.isInterface(objectClass.getModifiers()) ? 1 : 0) != 0, (Object)"Cannot construct an instance of an interface!");
        if (args == null) {
            args = new Object[]{null};
        }
        Constructor<T> ctor = ReflectionUtil.findConstructor(objectClass, args);
        try {
            return ctor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            SpongeCommon.logger().error("Couldn't find an appropriate constructor for " + objectClass.getCanonicalName() + "with the args: " + Arrays.toString(args), (Throwable)e);
            throw new IllegalArgumentException("Couldn't find an appropriate constructor for " + objectClass.getCanonicalName() + "the args: " + Arrays.toString(args));
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> objectClass, Object ... args) {
        Constructor<?>[] ctors = objectClass.getConstructors();
        if (args == null) {
            args = new Object[]{null};
        }
        block0: for (Constructor<?> ctor : ctors) {
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes.length != args.length) {
                for (Object object : args) {
                    if (object == null || !object.getClass().isArray()) continue;
                    Object[] objects = ReflectionUtil.deconstructArray(args).toArray();
                    return ReflectionUtil.findConstructor(objectClass, objects);
                }
                continue;
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> parameter;
                if (!ClassUtils.isAssignable(args[i] == null ? null : args[i].getClass(), parameter = paramTypes[i], (boolean)true)) continue block0;
            }
            return ctor;
        }
        throw new IllegalArgumentException("Applicable constructor not found for class: " + objectClass.getCanonicalName() + " with args: " + Arrays.toString(args));
    }

    private static List<Object> deconstructArray(Object[] objects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : objects) {
            if (object == null) {
                list.add(null);
                continue;
            }
            if (object.getClass().isArray()) {
                list.addAll(ReflectionUtil.deconstructArray((Object[])object));
                continue;
            }
            list.add(object);
        }
        return list;
    }

    private ReflectionUtil() {
    }
}

