/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.OverworldBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.biome.AttributedBiome;
import org.spongepowered.api.world.biome.provider.BiomeProvider;
import org.spongepowered.api.world.biome.provider.CheckerboardBiomeConfig;
import org.spongepowered.api.world.biome.provider.ConfigurableBiomeProvider;
import org.spongepowered.api.world.biome.provider.EndStyleBiomeConfig;
import org.spongepowered.api.world.biome.provider.LayeredBiomeConfig;
import org.spongepowered.api.world.biome.provider.MultiNoiseBiomeConfig;
import org.spongepowered.common.accessor.world.level.biome.BiomeSourceAccessor;
import org.spongepowered.common.accessor.world.level.biome.MultiNoiseBiomeSourceAccessor;
import org.spongepowered.common.accessor.world.level.biome.TheEndBiomeSourceAccessor;
import org.spongepowered.common.server.BootstrapProperties;

public final class SpongeBiomeProviderFactory
implements BiomeProvider.Factory {
    @Override
    public <T extends LayeredBiomeConfig> ConfigurableBiomeProvider<T> layered(T config) {
        Registry biomeRegistry = BootstrapProperties.registries.registryOrThrow(Registry.BIOME_REGISTRY);
        OverworldBiomeSource layeredBiomeProvider = new OverworldBiomeSource(config.seed(), config.largeBiomes(), false, biomeRegistry);
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (RegistryReference<org.spongepowered.api.world.biome.Biome> biome : config.biomes()) {
            biomes.add((Biome)biomeRegistry.get((ResourceLocation)biome.location()));
        }
        ((BiomeSourceAccessor)layeredBiomeProvider).accessor$possibleBiomes(biomes);
        return (ConfigurableBiomeProvider)layeredBiomeProvider;
    }

    @Override
    public ConfigurableBiomeProvider<LayeredBiomeConfig> overworld() {
        return (ConfigurableBiomeProvider)new OverworldBiomeSource(BootstrapProperties.worldGenSettings.seed(), false, false, BootstrapProperties.registries.registryOrThrow(Registry.BIOME_REGISTRY));
    }

    @Override
    public <T extends MultiNoiseBiomeConfig> ConfigurableBiomeProvider<T> multiNoise(T config) {
        Registry biomeRegistry = BootstrapProperties.registries.registryOrThrow(Registry.BIOME_REGISTRY);
        ArrayList<Pair<Biome.ClimateParameters, Supplier<Biome>>> attributedBiomes = new ArrayList<Pair<Biome.ClimateParameters, Supplier<Biome>>>();
        for (AttributedBiome attributedBiome : config.attributedBiomes()) {
            attributedBiomes.add(Pair.of((Object)((Biome.ClimateParameters)attributedBiome.attributes()), () -> (Biome)biomeRegistry.get((ResourceLocation)attributedBiome.biome().location())));
        }
        return (ConfigurableBiomeProvider)MultiNoiseBiomeSourceAccessor.invoker$new(config.seed(), attributedBiomes, (MultiNoiseBiomeSource.NoiseParameters)config.temperatureConfig(), (MultiNoiseBiomeSource.NoiseParameters)config.humidityConfig(), (MultiNoiseBiomeSource.NoiseParameters)config.altitudeConfig(), (MultiNoiseBiomeSource.NoiseParameters)config.weirdnessConfig(), Optional.empty());
    }

    @Override
    public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> nether() {
        return (ConfigurableBiomeProvider)MultiNoiseBiomeSource.Preset.NETHER.biomeSource(BootstrapProperties.registries.registryOrThrow(Registry.BIOME_REGISTRY), BootstrapProperties.worldGenSettings.seed());
    }

    @Override
    public <T extends EndStyleBiomeConfig> ConfigurableBiomeProvider<T> endStyle(T config) {
        Registry registry = BootstrapProperties.registries.registryOrThrow(Registry.BIOME_REGISTRY);
        return (ConfigurableBiomeProvider)TheEndBiomeSourceAccessor.invoker$new((Registry<Biome>)registry, config.seed(), (Biome)registry.get((ResourceLocation)config.endBiome().location()), (Biome)registry.get((ResourceLocation)config.highlandsBiome().location()), (Biome)registry.get((ResourceLocation)config.midlandsBiome().location()), (Biome)registry.get((ResourceLocation)config.islandsBiome().location()), (Biome)registry.get((ResourceLocation)config.barrensBiome().location()));
    }

    @Override
    public ConfigurableBiomeProvider<EndStyleBiomeConfig> end() {
        return (ConfigurableBiomeProvider)new TheEndBiomeSource(BootstrapProperties.registries.registryOrThrow(Registry.BIOME_REGISTRY), BootstrapProperties.worldGenSettings.seed());
    }

    @Override
    public <T extends CheckerboardBiomeConfig> ConfigurableBiomeProvider<T> checkerboard(T config) {
        ArrayList<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
        for (RegistryReference<org.spongepowered.api.world.biome.Biome> biome : config.biomes()) {
            biomes.add(() -> (Biome)BootstrapProperties.registries.registryOrThrow(Registry.BIOME_REGISTRY).get((ResourceLocation)biome.location()));
        }
        return (ConfigurableBiomeProvider)new CheckerboardColumnBiomeSource(biomes, config.scale());
    }

    @Override
    public BiomeProvider fixed(RegistryReference<org.spongepowered.api.world.biome.Biome> biome) {
        Objects.requireNonNull(biome, "biome");
        return (BiomeProvider)new FixedBiomeSource(() -> (Biome)biome.get(Sponge.server()));
    }
}

