/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.generation.config.FlatGeneratorConfig;
import org.spongepowered.api.world.generation.config.flat.LayerConfig;
import org.spongepowered.api.world.generation.config.structure.StructureGenerationConfig;
import org.spongepowered.common.accessor.world.level.levelgen.flat.FlatLevelGeneratorSettingsAccessor;
import org.spongepowered.common.server.BootstrapProperties;

public final class SpongeFlatGeneratorConfig {

    public static final class FactoryImpl
    implements FlatGeneratorConfig.Factory {
        @Override
        public FlatGeneratorConfig standard() {
            return (FlatGeneratorConfig)FlatLevelGeneratorSettings.getDefault((Registry)BootstrapProperties.registries.registryOrThrow(Registry.BIOME_REGISTRY));
        }
    }

    public static final class BuilderImpl
    implements FlatGeneratorConfig.Builder {
        public @Nullable StructureGenerationConfig structureConfig;
        public final List<LayerConfig> layers = new ArrayList<LayerConfig>();
        public @Nullable RegistryReference<org.spongepowered.api.world.biome.Biome> biome;
        public boolean performDecoration;
        public boolean populateLakes;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public FlatGeneratorConfig.Builder structureConfig(StructureGenerationConfig config) {
            this.structureConfig = Objects.requireNonNull(config, "config");
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder addLayer(int index, LayerConfig config) {
            this.layers.add(index, Objects.requireNonNull(config, "config"));
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder addLayer(LayerConfig config) {
            this.layers.add(Objects.requireNonNull(config, "config"));
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder addLayers(List<LayerConfig> layers) {
            this.layers.addAll((Collection<LayerConfig>)Objects.requireNonNull(layers, "layers"));
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder removeLayer(int index) {
            this.layers.remove(index);
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder biome(RegistryReference<org.spongepowered.api.world.biome.Biome> biome) {
            this.biome = Objects.requireNonNull(biome, "biome");
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder performDecoration(boolean performDecoration) {
            this.performDecoration = performDecoration;
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder populateLakes(boolean populateLakes) {
            this.populateLakes = populateLakes;
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder reset() {
            this.structureConfig = null;
            this.biome = null;
            this.layers.clear();
            this.performDecoration = false;
            this.populateLakes = true;
            return this;
        }

        @Override
        public FlatGeneratorConfig.Builder from(FlatGeneratorConfig value) {
            this.structureConfig = Objects.requireNonNull(value, "value").structureConfig();
            this.layers.addAll(value.layers());
            this.performDecoration = value.performDecoration();
            this.populateLakes = value.populateLakes();
            return this;
        }

        public @NonNull FlatGeneratorConfig build() {
            if (this.structureConfig == null) {
                throw new IllegalStateException("Flat generation requires structure configuration!");
            }
            if (this.biome == null) {
                throw new IllegalStateException("Flat generation requires a biome to be specified!");
            }
            if (this.layers.isEmpty()) {
                throw new IllegalStateException("Flat generation requires at least 1 Layer!");
            }
            return (FlatGeneratorConfig)FlatLevelGeneratorSettingsAccessor.invoker$new((Registry<Biome>)BootstrapProperties.registries.registryOrThrow(Registry.BIOME_REGISTRY), (StructureSettings)this.structureConfig, this.layers, this.populateLakes, this.performDecoration, Optional.of(() -> (Biome)BootstrapProperties.registries.registryOrThrow(Registry.BIOME_REGISTRY).get((ResourceLocation)this.biome.location())));
        }
    }
}

