/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.util.transformation.Transformation;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.common.world.volume.buffer.archetype.AbstractReferentArchetypeVolume;
import org.spongepowered.math.vector.Vector3i;

class ReferentSchematicVolume
extends AbstractReferentArchetypeVolume<Schematic>
implements Schematic {
    ReferentSchematicVolume(Schematic reference, Transformation transformation) {
        super(() -> reference, transformation);
    }

    @Override
    public Palette<BlockState, BlockType> blockPalette() {
        return this.applyReference(Schematic::blockPalette);
    }

    @Override
    public Palette<Biome, Biome> biomePalette() {
        return this.applyReference(Schematic::biomePalette);
    }

    @Override
    public DataView metadata() {
        return this.applyReference(Schematic::metadata);
    }

    @Override
    public <E> Optional<E> get(int x, int y, int z, Key<? extends Value<E>> key) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.get(transformed, key));
    }

    @Override
    public <E, V extends Value<E>> Optional<V> getValue(int x, int y, int z, Key<V> key) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.getValue(transformed, key));
    }

    @Override
    public boolean supports(int x, int y, int z, Key<?> key) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.supports(transformed, key));
    }

    @Override
    public Set<Key<?>> keys(int x, int y, int z) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.keys(transformed));
    }

    @Override
    public Set<Value.Immutable<?>> getValues(int x, int y, int z) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.getValues(transformed));
    }

    @Override
    public <E> DataTransactionResult offer(int x, int y, int z, Key<? extends Value<E>> key, E value) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.offer(transformed, key, value));
    }

    @Override
    public DataTransactionResult remove(int x, int y, int z, Key<?> key) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.remove(transformed, key));
    }

    @Override
    public DataTransactionResult undo(int x, int y, int z, DataTransactionResult result) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.undo(transformed, result));
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, ValueContainer from) {
        Vector3i transformed = this.inverseTransform(xTo, yTo, zTo);
        return this.applyReference(a -> a.copyFrom(transformed, from));
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, ValueContainer from, MergeFunction function) {
        Vector3i transformed = this.inverseTransform(xTo, yTo, zTo);
        return this.applyReference(a -> a.copyFrom(transformed, from, function));
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, int xFrom, int yFrom, int zFrom, MergeFunction function) {
        Vector3i transformed = this.inverseTransform(xTo, yTo, zTo);
        Vector3i from = this.inverseTransform(xFrom, yFrom, zFrom);
        return this.applyReference(a -> a.copyFrom(transformed, from, function));
    }

    @Override
    public boolean validateRawData(int x, int y, int z, DataView container) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.validateRawData(transformed, container));
    }

    @Override
    public void setRawData(int x, int y, int z, DataView container) throws InvalidDataException {
        Vector3i transformed = this.inverseTransform(x, y, z);
        this.consumeReference(a -> a.setRawData(transformed, container));
    }
}

