/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.biome;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.biome.Biome;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryKey;
import org.spongepowered.api.world.biome.Biomes;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.AbstractBiomeBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class ObjectArrayMutableBiomeBuffer
extends AbstractBiomeBuffer
implements BiomeVolume.Modifiable<ObjectArrayMutableBiomeBuffer> {
    private final RegistryKey<org.spongepowered.api.world.biome.Biome>[] biomes;
    private final Registry<org.spongepowered.api.world.biome.Biome> registry;

    public ObjectArrayMutableBiomeBuffer(Vector3i start, Vector3i size, Registry<org.spongepowered.api.world.biome.Biome> biomeRegistry) {
        super(start, size);
        this.biomes = new RegistryKey[size.x() * size.y() * size.z()];
        this.registry = biomeRegistry;
        Arrays.fill(this.biomes, Biomes.OCEAN);
    }

    @Override
    public org.spongepowered.api.world.biome.Biome biome(int x, int y, int z) {
        this.checkRange(x, y, z);
        RegistryKey<org.spongepowered.api.world.biome.Biome> key = this.biomes[this.getIndex(x, y, z)];
        return (org.spongepowered.api.world.biome.Biome)this.registry.value(key);
    }

    public Biome getNativeBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        RegistryKey<org.spongepowered.api.world.biome.Biome> key = this.biomes[this.getIndex(x, y, z)];
        return (Biome)this.registry.value(key);
    }

    @Override
    public boolean setBiome(int x, int y, int z, org.spongepowered.api.world.biome.Biome biome) {
        Objects.requireNonNull(biome, "biome");
        this.checkRange(x, y, z);
        return this.registry.findValueKey(biome).map(key -> {
            this.biomes[this.getIndex((int)x, (int)y, (int)z)] = RegistryKey.of(this.registry.type(), key);
            return true;
        }).orElse(false);
    }

    public boolean setBiome(BlockPos pos, Biome biome) {
        Objects.requireNonNull(biome, "biome");
        Objects.requireNonNull(pos, "pos");
        this.checkRange(pos.getX(), pos.getY(), pos.getZ());
        return this.registry.findValueKey((org.spongepowered.api.world.biome.Biome)biome).map(key -> {
            this.biomes[this.getIndex((int)pos.getX(), (int)pos.getY(), (int)pos.getZ())] = RegistryKey.of(this.registry.type(), key);
            return true;
        }).orElse(false);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectArrayMutableBiomeBuffer that = (ObjectArrayMutableBiomeBuffer)o;
        return Arrays.equals(this.biomes, that.biomes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.biomes);
        return result;
    }

    @Override
    public VolumeStream<ObjectArrayMutableBiomeBuffer, org.spongepowered.api.world.biome.Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.min();
        Vector3i blockMax = this.max();
        VolumeStreamUtils.validateStreamArgs(min, max, blockMin, blockMax, options);
        RegistryKey[] buffer = options.carbonCopy() ? Arrays.copyOf(this.biomes, this.biomes.length) : this.biomes;
        Stream stateStream = IntStream.range(blockMin.x(), blockMax.x() + 1).mapToObj(x -> IntStream.range(blockMin.z(), blockMax.z() + 1).mapToObj(z -> IntStream.range(blockMin.y(), blockMax.y() + 1).mapToObj(y -> VolumeElement.of(this, () -> {
            RegistryKey key = buffer[this.getIndex(x, y, z)];
            org.spongepowered.api.world.biome.Biome biome = (org.spongepowered.api.world.biome.Biome)this.registry.value(key);
            return biome;
        }, new Vector3d((float)x, (float)y, (float)z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<ObjectArrayMutableBiomeBuffer, org.spongepowered.api.world.biome.Biome>(stateStream, () -> this);
    }
}

