/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.applaunch;

import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.Manifest;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import org.spongepowered.vanilla.applaunch.AppLaunchTargets;

public final class AppCommandLine {
    private static final OptionParser PARSER = new OptionParser();
    private static final ArgumentAcceptingOptionSpec<String> LAUNCH_TARGET_ARG = PARSER.accepts("launchTarget", "Launch Target").withRequiredArg();
    private static final ArgumentAcceptingOptionSpec<Path> GAME_DIRECTORY_ARG = PARSER.accepts("gameDir", "Alternative game directory").withRequiredArg().withValuesConvertedBy(new PathConverter(PathProperties.DIRECTORY_EXISTING)).defaultsTo(Paths.get(".", new String[0]), (Path[])new Path[0]);
    public static String[] RAW_ARGS;
    public static AppLaunchTargets launchTarget;
    public static Path gameDirectory;

    public static void configure(String[] args) throws Exception {
        PARSER.allowsUnrecognizedOptions();
        OptionSet options = PARSER.parse(args);
        String launchTarget = options.valueOf(LAUNCH_TARGET_ARG);
        boolean manifestTarget = false;
        if (launchTarget == null) {
            Path executionJar = Paths.get(AppCommandLine.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            try (FileSystem system = FileSystems.newFileSystem(executionJar, (ClassLoader)null);){
                Path manifestFile = system.getPath("META-INF", "MANIFEST.MF");
                if (Files.notExists(manifestFile, new LinkOption[0])) {
                    throw new RuntimeException("The installer contains no manifest!");
                }
                try (InputStream stream = Files.newInputStream(manifestFile, new OpenOption[0]);){
                    Manifest manifest = new Manifest(stream);
                    launchTarget = manifest.getMainAttributes().getValue("Launch-Target");
                    manifestTarget = true;
                }
            }
        }
        if (launchTarget == null) {
            throw new RuntimeException("No launch target has been specified! Check your run configs/manifest...");
        }
        AppCommandLine.launchTarget = AppLaunchTargets.from(launchTarget);
        if (AppCommandLine.launchTarget == null) {
            throw new RuntimeException("Invalid launch target specified!");
        }
        if (manifestTarget) {
            String[] temp = new String[args.length + 2];
            System.arraycopy(args, 0, temp, 0, args.length);
            temp[args.length] = "--launchTarget";
            temp[args.length + 1] = launchTarget;
            args = temp;
        }
        gameDirectory = options.valueOf(GAME_DIRECTORY_ARG);
        RAW_ARGS = args;
    }

    private AppCommandLine() {
    }
}

