/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.server.packs;

import java.nio.file.FileSystem;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import org.apache.commons.io.FilenameUtils;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.builtin.jvm.locator.JVMPluginResource;
import org.spongepowered.vanilla.bridge.server.packs.repository.PackRepositoryBridge_Vanilla;
import org.spongepowered.vanilla.launch.plugin.VanillaPluginManager;
import org.spongepowered.vanilla.server.packs.PluginPackResources;

public final class PluginRepositorySource
implements RepositorySource {
    private final PackRepository repository;

    public PluginRepositorySource(PackRepository repository) {
        this.repository = repository;
    }

    public void loadPacks(Consumer<Pack> callback, Pack.PackConstructor constructor) {
        VanillaPluginManager pluginManager = (VanillaPluginManager)((Launch)Launch.instance()).pluginManager();
        for (PluginContainer pluginContainer : pluginManager.plugins()) {
            String extension;
            String id = "plugin-" + pluginContainer.metadata().id();
            PluginResource resource = pluginManager.resource(pluginContainer);
            Supplier<FileSystem> fileSystemSupplier = null;
            if (resource instanceof JVMPluginResource && "jar".equals(extension = FilenameUtils.getExtension((String)resource.path().getFileName().toString()))) {
                fileSystemSupplier = () -> ((JVMPluginResource)((JVMPluginResource)resource)).fileSystem();
            }
            PluginPackResources packResources = new PluginPackResources(id, pluginContainer, fileSystemSupplier);
            Pack pack = Pack.create((String)id, (boolean)true, () -> packResources, (Pack.PackConstructor)constructor, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.DEFAULT);
            ((PackRepositoryBridge_Vanilla)this.repository).bridge$registerResourcePack(pluginContainer, pack);
            callback.accept(pack);
        }
    }
}

