/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.internal;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.fart.api.Transformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public final class FFLineFixer
implements Transformer {
    private final Map<String, NavigableMap<Integer, Integer>> classes = new HashMap<String, NavigableMap<Integer, Integer>>();

    public FFLineFixer(Consumer<String> debug, File data) {
        try (FileInputStream fis = new FileInputStream(data);
             ZipInputStream zip = new ZipInputStream(fis);){
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                byte[] extra = entry.getExtra();
                if (extra == null || !entry.getName().endsWith(".java")) continue;
                ByteBuffer buf = ByteBuffer.wrap(extra);
                buf.order(ByteOrder.LITTLE_ENDIAN);
                while (buf.hasRemaining()) {
                    short id = buf.getShort();
                    short len = buf.getShort();
                    if (id == 17990) {
                        String cls = entry.getName().substring(0, entry.getName().length() - 5);
                        debug.accept("Lines: " + cls);
                        byte ver = buf.get();
                        if (ver != 1) {
                            throw new IllegalStateException("Invalid FF code line version for " + entry.getName());
                        }
                        int count = (len - 1) / 4;
                        TreeMap<Integer, Integer> lines = new TreeMap<Integer, Integer>();
                        for (int x = 0; x < count; ++x) {
                            short oline = buf.getShort();
                            short nline = buf.getShort();
                            debug.accept("  " + oline + ' ' + nline);
                            lines.put(Integer.valueOf(oline), Integer.valueOf(nline));
                        }
                        this.classes.put(cls, lines);
                        continue;
                    }
                    buf.position(buf.position() + len);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Transformer.ClassEntry process(Transformer.ClassEntry entry) {
        NavigableMap<Integer, Integer> lines;
        String owner = entry.getClassName();
        int idx = owner.indexOf(36);
        if (idx != -1) {
            owner = owner.substring(0, idx);
        }
        if ((lines = this.classes.get(owner)) == null) {
            return entry;
        }
        ClassReader reader = new ClassReader(entry.getData());
        ClassWriter writer = new ClassWriter(reader, 0);
        Fixer fixer = new Fixer(writer, lines);
        reader.accept(fixer, 0);
        if (!fixer.madeChange()) {
            return entry;
        }
        return Transformer.ClassEntry.create(entry.getName(), entry.getTime(), writer.toByteArray());
    }

    private static class Fixer
    extends ClassVisitor {
        private final NavigableMap<Integer, Integer> lines;
        private boolean madeChange = false;

        public Fixer(ClassVisitor parent, NavigableMap<Integer, Integer> lines) {
            super(589824, parent);
            this.lines = lines;
        }

        public boolean madeChange() {
            return this.madeChange;
        }

        @Override
        public final MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor parent = super.visitMethod(access, name, descriptor, signature, exceptions);
            return new MethodVisitor(589824, parent){

                @Override
                public void visitLineNumber(int line, Label start) {
                    Map.Entry nline = lines.higherEntry(line);
                    if (nline != null) {
                        madeChange = true;
                        super.visitLineNumber((Integer)nline.getValue(), start);
                    } else {
                        super.visitLineNumber(line, start);
                    }
                }
            };
        }
    }
}

