/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.util.RGBLike;
import org.checkerframework.common.value.qual.IntRange;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3f;
import org.spongepowered.math.vector.Vector3i;

public final class Color
implements DataSerializable,
RGBLike {
    private static final int MASK = 255;
    public static final Color BLACK = Color.ofRgb(0);
    public static final Color GRAY = Color.ofRgb(0x808080);
    public static final Color WHITE = Color.ofRgb(0xFFFFFF);
    public static final Color BLUE = Color.ofRgb(255);
    public static final Color GREEN = Color.ofRgb(32768);
    public static final Color LIME = Color.ofRgb(65280);
    public static final Color RED = Color.ofRgb(0xFF0000);
    public static final Color YELLOW = Color.ofRgb(0xFFFF00);
    public static final Color MAGENTA = Color.ofRgb(0xFF00FF);
    public static final Color PURPLE = Color.ofRgb(0xAA00FF);
    public static final Color DARK_CYAN = Color.ofRgb(35723);
    public static final Color DARK_GREEN = Color.ofRgb(25600);
    public static final Color DARK_MAGENTA = Color.ofRgb(0x8B008B);
    public static final Color CYAN = Color.ofRgb(65535);
    public static final Color NAVY = Color.ofRgb(128);
    public static final Color PINK = Color.ofRgb(0xFF00AA);
    private final byte red;
    private final byte green;
    private final byte blue;
    private final int rgb;

    public static Color ofRgb(int hex) {
        return Color.ofRgb(hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF);
    }

    public static Color ofRgb(int red, int green, int blue) {
        return new Color(red, green, blue);
    }

    public static Color of(java.awt.Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color of(Vector3i vector3i) {
        return new Color(vector3i.x(), vector3i.y(), vector3i.z());
    }

    public static Color of(Vector3f vector3f) {
        return new Color(Math.round(vector3f.x()), Math.round(vector3f.y()), Math.round(vector3f.z()));
    }

    public static Color of(Vector3d vector3d) {
        return new Color((int)Math.round(vector3d.x()), (int)Math.round(vector3d.y()), (int)Math.round(vector3d.z()));
    }

    public static Color mixDyeColors(DyeColor ... colors) {
        Objects.requireNonNull(colors, "No nulls allowed!");
        Color[] actualColors = new Color[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            actualColors[i] = colors[i].color();
        }
        return Color.mixColors(actualColors);
    }

    public static Color mixColors(Color ... colors) {
        Objects.requireNonNull(colors, "No null colors allowed!");
        if (colors.length <= 0) {
            throw new IllegalArgumentException("Cannot have an empty color array!");
        }
        if (colors.length == 1) {
            return colors[0];
        }
        int red = colors[0].red();
        int green = colors[0].green();
        int blue = colors[0].blue();
        for (int i = 1; i < colors.length; ++i) {
            Objects.requireNonNull(colors[i], "No null colors allowed!");
            red += colors[i].red();
            green += colors[i].green();
            blue += colors[i].blue();
        }
        int averageRed = Math.round((float)red / (float)colors.length);
        int averageGreen = Math.round((float)green / (float)colors.length);
        int averageBlue = Math.round((float)blue / (float)colors.length);
        return Color.ofRgb(averageRed, averageGreen, averageBlue);
    }

    private Color(int red, int green, int blue) {
        this.red = (byte)(red & 0xFF);
        this.green = (byte)(green & 0xFF);
        this.blue = (byte)(blue & 0xFF);
        this.rgb = (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | (this.blue & 0xFF) << 0;
    }

    public @IntRange(from=0L, to=255L) int red() {
        return 0xFF & this.red;
    }

    public Color withRed(int red) {
        return Color.ofRgb(red, this.green(), this.blue());
    }

    public @IntRange(from=0L, to=255L) int green() {
        return 0xFF & this.green;
    }

    public Color withGreen(int green) {
        return Color.ofRgb(this.red(), green, this.blue());
    }

    public @IntRange(from=0L, to=255L) int blue() {
        return 0xFF & this.blue;
    }

    public Color withBlue(int blue) {
        return Color.ofRgb(this.red(), this.green(), blue);
    }

    public java.awt.Color asJavaColor() {
        return new java.awt.Color(this.red(), this.green(), this.blue());
    }

    public int rgb() {
        return this.rgb;
    }

    public Color mixWithColors(Color ... colors) {
        Color[] newColorArray = new Color[colors.length + 1];
        newColorArray[0] = this;
        System.arraycopy(colors, 0, newColorArray, 1, colors.length);
        return Color.mixColors(newColorArray);
    }

    public Color mixWithDyes(DyeColor ... dyeColors) {
        Color[] newColorArray = new Color[dyeColors.length + 1];
        newColorArray[0] = this;
        for (int i = 0; i < dyeColors.length; ++i) {
            newColorArray[i + 1] = dyeColors[i].color();
        }
        return Color.mixColors(newColorArray);
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Queries.COLOR_RED, this.red()).set(Queries.COLOR_GREEN, this.green()).set(Queries.COLOR_BLUE, this.blue());
    }

    public int hashCode() {
        return Objects.hash(Color.class, this.red, this.green, this.blue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Color other = (Color)obj;
        return this.red == other.red && this.green == other.green && this.blue == other.blue;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("red", this.red()).add("green", this.green()).add("blue", this.blue()).toString();
    }

    public static final class Builder
    extends AbstractDataBuilder<Color> {
        public Builder() {
            super(Color.class, 1);
        }

        @Override
        protected Optional<Color> buildContent(DataView container) throws InvalidDataException {
            if (!container.contains(Queries.COLOR_RED, Queries.COLOR_GREEN, Queries.COLOR_BLUE)) {
                return Optional.empty();
            }
            try {
                int red = container.getInt(Queries.COLOR_RED).get();
                int green = container.getInt(Queries.COLOR_GREEN).get();
                int blue = container.getInt(Queries.COLOR_BLUE).get();
                return Optional.of(Color.ofRgb(red, green, blue));
            }
            catch (Exception e) {
                throw new InvalidDataException("Could not parse some data.", e);
            }
        }
    }
}

