/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import org.spongepowered.api.effect.Viewer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.service.context.ContextSource;
import org.spongepowered.api.util.annotation.DoNotStore;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.LocationCreator;
import org.spongepowered.api.world.WorldLike;
import org.spongepowered.api.world.chunk.WorldChunk;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolumeCreator;
import org.spongepowered.api.world.volume.block.PhysicsAwareMutableBlockVolume;
import org.spongepowered.api.world.weather.WeatherUniverse;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@DoNotStore
public interface World<W extends World<W, L>, L extends Location<W, L>>
extends ForwardingAudience,
WorldLike<W>,
LocationCreator<W, L>,
PhysicsAwareMutableBlockVolume<W>,
ContextSource,
Viewer,
ArchetypeVolumeCreator,
WeatherUniverse,
RegistryHolder {
    public WorldProperties properties();

    @Override
    default public W world() {
        return (W)this;
    }

    public boolean isLoaded();

    @Override
    public Collection<? extends Player> players();

    default public Iterable<? extends Audience> audiences() {
        return this.players();
    }

    default public Optional<? extends Player> closestPlayer(Vector3i position, double distance) {
        Objects.requireNonNull(position, "position");
        return this.closestPlayer(position.x(), position.y(), position.z(), distance, player -> true);
    }

    default public Optional<? extends Player> closestPlayer(Vector3i position, double distance, Predicate<? super Player> predicate) {
        Objects.requireNonNull(position, "position");
        Objects.requireNonNull(predicate, "predicate");
        return this.closestPlayer(position.x(), position.y(), position.z(), distance, predicate);
    }

    default public Optional<? extends Player> closestPlayer(Entity entity, double distance) {
        Objects.requireNonNull(entity, "entity");
        Vector3d position = entity.location().position();
        return this.closestPlayer(position.floorX(), position.floorY(), position.floorZ(), distance, player -> true);
    }

    default public Optional<? extends Player> closestPlayer(Entity entity, double distance, Predicate<? super Player> predicate) {
        Objects.requireNonNull(entity, "entity");
        Objects.requireNonNull(predicate, "predicate");
        Vector3d position = entity.location().position();
        return this.closestPlayer(position.floorX(), position.floorY(), position.floorZ(), distance, predicate);
    }

    default public Optional<? extends Player> closestPlayer(int x, int y, int z, double distance) {
        return this.closestPlayer(x, y, z, distance, player -> true);
    }

    public Optional<? extends Player> closestPlayer(int var1, int var2, int var3, double var4, Predicate<? super Player> var6);

    public WorldChunk chunkAtBlock(Vector3i var1);

    public WorldChunk chunkAtBlock(int var1, int var2, int var3);

    default public WorldChunk chunk(Vector3i chunkPos) {
        Objects.requireNonNull(chunkPos, "chunkPos");
        return this.chunk(chunkPos.x(), chunkPos.y(), chunkPos.z());
    }

    public WorldChunk chunk(int var1, int var2, int var3);

    default public Optional<WorldChunk> loadChunk(Vector3i chunkPosition, boolean shouldGenerate) {
        Objects.requireNonNull(chunkPosition, "chunkPosition");
        return this.loadChunk(chunkPosition.x(), chunkPosition.y(), chunkPosition.z(), shouldGenerate);
    }

    public Optional<WorldChunk> loadChunk(int var1, int var2, int var3, boolean var4);

    public Iterable<WorldChunk> loadedChunks();
}

