/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.biome.provider;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.BiomeFinder;
import org.spongepowered.api.world.biome.provider.CheckerboardBiomeConfig;
import org.spongepowered.api.world.biome.provider.ConfigurableBiomeProvider;
import org.spongepowered.api.world.biome.provider.EndStyleBiomeConfig;
import org.spongepowered.api.world.biome.provider.MultiNoiseBiomeConfig;

public interface BiomeProvider
extends BiomeFinder {
    public static ConfigurableBiomeProvider<MultiNoiseBiomeConfig> overworld() {
        return Sponge.game().factoryProvider().provide(Factory.class).overworld();
    }

    public static <T extends MultiNoiseBiomeConfig> ConfigurableBiomeProvider<T> multiNoise(T config) {
        return Sponge.game().factoryProvider().provide(Factory.class).multiNoise(config);
    }

    public static ConfigurableBiomeProvider<MultiNoiseBiomeConfig> nether() {
        return Sponge.game().factoryProvider().provide(Factory.class).nether();
    }

    public static <T extends EndStyleBiomeConfig> ConfigurableBiomeProvider<T> endStyle(T config) {
        return Sponge.game().factoryProvider().provide(Factory.class).endStyle(config);
    }

    public static ConfigurableBiomeProvider<EndStyleBiomeConfig> end() {
        return Sponge.game().factoryProvider().provide(Factory.class).end();
    }

    public static <T extends CheckerboardBiomeConfig> ConfigurableBiomeProvider<T> checkerboard(T config) {
        return Sponge.game().factoryProvider().provide(Factory.class).checkerboard(config);
    }

    public static BiomeProvider fixed(RegistryReference<Biome> biome) {
        return Sponge.game().factoryProvider().provide(Factory.class).fixed(Objects.requireNonNull(biome, "biome"));
    }

    public List<Biome> choices();

    public Set<Biome> within(int var1, int var2, int var3, int var4);

    public static interface Factory {
        public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> overworld();

        public <T extends MultiNoiseBiomeConfig> ConfigurableBiomeProvider<T> multiNoise(T var1);

        public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> nether();

        public <T extends EndStyleBiomeConfig> ConfigurableBiomeProvider<T> endStyle(T var1);

        public ConfigurableBiomeProvider<EndStyleBiomeConfig> end();

        public <T extends CheckerboardBiomeConfig> ConfigurableBiomeProvider<T> checkerboard(T var1);

        public BiomeProvider fixed(RegistryReference<Biome> var1);
    }
}

