/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.game;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.math.vector.Vector3i;

public interface ChunkVolume
extends Volume {
    public ChunkLayout chunkLayout();

    public Chunk<@NonNull ?> chunk(int var1, int var2, int var3);

    default public Chunk<@NonNull ?> chunk(Vector3i chunkPosition) {
        Objects.requireNonNull(chunkPosition, "chunkPosition");
        return this.chunk(chunkPosition.x(), chunkPosition.y(), chunkPosition.z());
    }

    default public Chunk<@NonNull ?> chunkAtBlock(Vector3i blockPosition) {
        Objects.requireNonNull(blockPosition, "blockPosition");
        return this.chunkAtBlock(blockPosition.x(), blockPosition.y(), blockPosition.z());
    }

    public Chunk<@NonNull ?> chunkAtBlock(int var1, int var2, int var3);

    public boolean isChunkLoaded(int var1, int var2, int var3, boolean var4);

    default public boolean isChunkLoadedAtBlock(int bx, int by, int bz, boolean allowEmpty) {
        return this.isChunkLoaded(this.chunkLayout().forceToChunk(bx, by, bz), allowEmpty);
    }

    default public boolean isChunkLoaded(Vector3i chunkPosition, boolean allowEmpty) {
        Objects.requireNonNull(chunkPosition, "chunkPosition");
        return this.isChunkLoaded(chunkPosition.x(), chunkPosition.y(), chunkPosition.z(), allowEmpty);
    }

    default public boolean isChunkLoadedAtBlock(Vector3i position, boolean allowEmpty) {
        Objects.requireNonNull(position, "position");
        return this.isChunkLoaded(this.chunkLayout().forceToChunk(position), allowEmpty);
    }

    public boolean hasChunk(int var1, int var2, int var3);

    default public boolean hasChunkAtBlock(int bx, int by, int bz) {
        return this.hasChunk(this.chunkLayout().forceToChunk(bx, by, bz));
    }

    default public boolean hasChunk(Vector3i chunkPosition) {
        return this.hasChunk(chunkPosition.x(), chunkPosition.y(), chunkPosition.z());
    }

    default public boolean hasChunkAtBlock(Vector3i blockPosition) {
        return this.hasChunk(this.chunkLayout().forceToChunk(Objects.requireNonNull(blockPosition, "blockPosition")));
    }
}

