/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.state.BooleanStateProperty;
import org.spongepowered.api.state.EnumStateProperty;
import org.spongepowered.api.state.IntegerStateProperty;

public final class BlockStatePropertyImpl {
    private static @Nullable Map<String, Property<?>> PROPERTIES;

    private static Map<Property<?>, String> vanillaProperties() {
        IdentityHashMap vanillaMap = new IdentityHashMap();
        for (Field field : BlockStateProperties.class.getDeclaredFields()) {
            try {
                Object property = field.get(null);
                if (!(property instanceof Property)) continue;
                vanillaMap.put((Property)property, field.getName());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return vanillaMap;
    }

    private static Map<String, Property<?>> properties() {
        if (PROPERTIES != null) {
            return PROPERTIES;
        }
        Map<Property<?>, String> vanillaMap = BlockStatePropertyImpl.vanillaProperties();
        HashMap propertyUsages = new HashMap();
        HashMap propertyCount = new HashMap();
        for (Block block : Registry.BLOCK) {
            for (Property property : block.defaultBlockState().getProperties()) {
                String name = vanillaMap.computeIfAbsent(property, p -> {
                    int cnt = propertyCount.computeIfAbsent(property.getName(), n -> 0) + 1;
                    return property.getName() + "_" + cnt;
                });
                propertyUsages.put(name, property);
            }
        }
        PROPERTIES = propertyUsages;
        return propertyUsages;
    }

    private BlockStatePropertyImpl() {
    }

    public static class EnumFactoryImpl
    implements EnumStateProperty.Factory {
        public EnumStateProperty<?> of(String name) {
            return (EnumStateProperty)BlockStatePropertyImpl.properties().get(name);
        }
    }

    public static class IntegerFactoryImpl
    implements IntegerStateProperty.Factory {
        @Override
        public IntegerStateProperty of(String name) {
            return (IntegerStateProperty)BlockStatePropertyImpl.properties().get(name);
        }
    }

    public static class BooleanFactoryImpl
    implements BooleanStateProperty.Factory {
        @Override
        public BooleanStateProperty of(String name) {
            return (BooleanStateProperty)BlockStatePropertyImpl.properties().get(name);
        }
    }
}

